/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerState;

public class ServerboundPlayerCommandPacket
implements MinecraftPacket {
    private final int entityId;
    @lombok.NonNull
    private final PlayerState state;
    private final int jumpBoost;

    public ServerboundPlayerCommandPacket(int entityId, PlayerState state) {
        this(entityId, state, 0);
    }

    public ServerboundPlayerCommandPacket(ByteBuf in) {
        this.entityId = MinecraftTypes.readVarInt(in);
        this.state = PlayerState.from(MinecraftTypes.readVarInt(in));
        this.jumpBoost = MinecraftTypes.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.entityId);
        MinecraftTypes.writeVarInt(out, this.state.ordinal());
        MinecraftTypes.writeVarInt(out, this.jumpBoost);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @lombok.NonNull
    public PlayerState getState() {
        return this.state;
    }

    public int getJumpBoost() {
        return this.jumpBoost;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundPlayerCommandPacket)) {
            return false;
        }
        ServerboundPlayerCommandPacket other = (ServerboundPlayerCommandPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.getJumpBoost() != other.getJumpBoost()) {
            return false;
        }
        PlayerState this$state = this.getState();
        PlayerState other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundPlayerCommandPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getJumpBoost();
        PlayerState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundPlayerCommandPacket(entityId=" + this.getEntityId() + ", state=" + String.valueOf((Object)this.getState()) + ", jumpBoost=" + this.getJumpBoost() + ")";
    }

    public @NonNull ServerboundPlayerCommandPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ServerboundPlayerCommandPacket(entityId, this.state, this.jumpBoost);
    }

    public @NonNull ServerboundPlayerCommandPacket withState(@lombok.NonNull PlayerState state) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        return this.state == state ? this : new ServerboundPlayerCommandPacket(this.entityId, state, this.jumpBoost);
    }

    public @NonNull ServerboundPlayerCommandPacket withJumpBoost(int jumpBoost) {
        return this.jumpBoost == jumpBoost ? this : new ServerboundPlayerCommandPacket(this.entityId, this.state, jumpBoost);
    }

    public ServerboundPlayerCommandPacket(int entityId, @lombok.NonNull PlayerState state, int jumpBoost) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        this.entityId = entityId;
        this.state = state;
        this.jumpBoost = jumpBoost;
    }
}

