/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.entity.EntityTypeDefinition;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

@BlockEntity(type={BlockEntityType.MOB_SPAWNER})
public class SpawnerBlockEntityTranslator
extends BlockEntityTranslator {
    @Override
    public NbtMap getBlockEntityTag(GeyserSession session, BlockEntityType type, int x, int y, int z, @Nullable NbtMap javaNbt, BlockState blockState) {
        NbtMap entityTag;
        if (javaNbt == null) {
            return super.getBlockEntityTag(session, type, x, y, z, javaNbt, blockState);
        }
        NbtMap spawnData = javaNbt.getCompound("SpawnData");
        if (spawnData != null && (entityTag = spawnData.getCompound("entity")).isEmpty()) {
            Vector3i position = Vector3i.from(x, y, z);
            UpdateBlockPacket emptyBlockPacket = new UpdateBlockPacket();
            emptyBlockPacket.setDataLayer(0);
            emptyBlockPacket.setBlockPosition(position);
            emptyBlockPacket.setDefinition(session.getBlockMappings().getBedrockAir());
            session.sendUpstreamPacket(emptyBlockPacket);
            UpdateBlockPacket spawnerBlockPacket = new UpdateBlockPacket();
            spawnerBlockPacket.setDataLayer(0);
            spawnerBlockPacket.setBlockPosition(position);
            spawnerBlockPacket.setDefinition(session.getBlockMappings().getMobSpawnerBlock());
            session.sendUpstreamPacket(spawnerBlockPacket);
        }
        return super.getBlockEntityTag(session, type, x, y, z, javaNbt, blockState);
    }

    @Override
    public void translateTag(GeyserSession session, NbtMapBuilder bedrockNbt, NbtMap javaNbt, BlockState blockState) {
        Object current = javaNbt.get("MaxNearbyEntities");
        if (current != null) {
            bedrockNbt.put("MaxNearbyEntities", current);
        }
        if ((current = javaNbt.get("RequiredPlayerRange")) != null) {
            bedrockNbt.put("RequiredPlayerRange", current);
        }
        if ((current = javaNbt.get("SpawnCount")) != null) {
            bedrockNbt.put("SpawnCount", current);
        }
        if ((current = javaNbt.get("MaxSpawnDelay")) != null) {
            bedrockNbt.put("MaxSpawnDelay", current);
        }
        if ((current = javaNbt.get("Delay")) != null) {
            bedrockNbt.put("Delay", current);
        }
        if ((current = javaNbt.get("SpawnRange")) != null) {
            bedrockNbt.put("SpawnRange", current);
        }
        if ((current = javaNbt.get("MinSpawnDelay")) != null) {
            bedrockNbt.put("MinSpawnDelay", current);
        }
        SpawnerBlockEntityTranslator.translateSpawnData(bedrockNbt, javaNbt.getCompound("SpawnData", null));
        bedrockNbt.put("isMovable", (Object)1);
    }

    private static void translateSpawnData(@NonNull NbtMapBuilder builder, @Nullable NbtMap spawnData) {
        if (spawnData == null) {
            return;
        }
        NbtMap entityTag = spawnData.getCompound("entity");
        String entityId = entityTag.getString("id");
        if (entityId != null) {
            builder.put("EntityIdentifier", (Object)entityId);
            EntityTypeDefinition definition = (EntityTypeDefinition)Registries.JAVA_ENTITY_IDENTIFIERS.get(entityId);
            if (definition != null) {
                builder.putFloat("DisplayEntityWidth", definition.width());
                builder.putFloat("DisplayEntityHeight", definition.height());
                builder.putFloat("DisplayEntityScale", 1.0f);
            }
        }
    }
}

