/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import java.util.concurrent.TimeUnit;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityLinkData;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.AutoCraftRecipeAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.CraftRecipeAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityLinkPacket;
import org.geysermc.geyser.entity.VanillaEntities;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.MerchantContainer;
import org.geysermc.geyser.inventory.SlotType;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.inventory.updater.UIInventoryUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.BaseInventoryTranslator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundSelectTradePacket;

public class MerchantInventoryTranslator
extends BaseInventoryTranslator<MerchantContainer> {
    private final InventoryUpdater updater = UIInventoryUpdater.INSTANCE;

    public MerchantInventoryTranslator() {
        super(3);
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        return switch (slot) {
            case 0 -> 4;
            case 1 -> 5;
            case 2 -> 50;
            default -> super.javaSlotToBedrock(slot);
        };
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot, MerchantContainer container) {
        return switch (slot) {
            case 0 -> new BedrockContainerSlot(ContainerSlotType.TRADE2_INGREDIENT_1, 4);
            case 1 -> new BedrockContainerSlot(ContainerSlotType.TRADE2_INGREDIENT_2, 5);
            case 2 -> new BedrockContainerSlot(ContainerSlotType.TRADE2_RESULT, 50);
            default -> super.javaSlotToBedrockContainer(slot, container);
        };
    }

    @Override
    public int bedrockSlotToJava(ItemStackRequestSlotData slotInfoData) {
        return switch (slotInfoData.getContainerName().getContainer()) {
            case ContainerSlotType.TRADE2_INGREDIENT_1 -> 0;
            case ContainerSlotType.TRADE2_INGREDIENT_2 -> 1;
            case ContainerSlotType.TRADE2_RESULT, ContainerSlotType.CREATED_OUTPUT -> 2;
            default -> super.bedrockSlotToJava(slotInfoData);
        };
    }

    @Override
    public SlotType getSlotType(int javaSlot) {
        if (javaSlot == 2) {
            return SlotType.OUTPUT;
        }
        return SlotType.NORMAL;
    }

    @Override
    public boolean prepareInventory(GeyserSession session, MerchantContainer container) {
        if (container.getVillager() == null) {
            EntitySpawnContext context = EntitySpawnContext.DUMMY_CONTEXT.apply(session, null, VanillaEntities.VILLAGER);
            context.position(session.getPlayerEntity().position().sub(0.0f, 3.0f, 0.0f));
            Entity villager = new Entity(context){

                @Override
                protected void initializeMetadata() {
                    this.dirtyMetadata.put(EntityDataTypes.SCALE, Float.valueOf(0.0f));
                    this.dirtyMetadata.put(EntityDataTypes.WIDTH, Float.valueOf(0.0f));
                    this.dirtyMetadata.put(EntityDataTypes.HEIGHT, Float.valueOf(0.0f));
                }
            };
            villager.spawnEntity();
            SetEntityLinkPacket linkPacket = new SetEntityLinkPacket();
            EntityLinkData.Type type = EntityLinkData.Type.PASSENGER;
            linkPacket.setEntityLink(new EntityLinkData(session.getPlayerEntity().geyserId(), villager.geyserId(), type, true, false, 0.0f));
            session.sendUpstreamPacket(linkPacket);
            container.setVillager(villager);
        }
        return true;
    }

    @Override
    public void openInventory(GeyserSession session, MerchantContainer container) {
    }

    @Override
    public void closeInventory(GeyserSession session, MerchantContainer container, boolean force) {
        if (container.getVillager() != null) {
            container.getVillager().despawnEntity();
        }
    }

    @Override
    public ItemStackResponse translateCraftingRequest(GeyserSession session, MerchantContainer container, ItemStackRequest request) {
        int tradeChoice = ((CraftRecipeAction)request.getActions()[0]).getRecipeNetworkId() - 1;
        return this.handleTrade(session, container, request, tradeChoice);
    }

    @Override
    public ItemStackResponse translateAutoCraftingRequest(GeyserSession session, MerchantContainer container, ItemStackRequest request) {
        int tradeChoice = ((AutoCraftRecipeAction)request.getActions()[0]).getRecipeNetworkId() - 1;
        return this.handleTrade(session, container, request, tradeChoice);
    }

    private ItemStackResponse handleTrade(GeyserSession session, MerchantContainer container, ItemStackRequest request, int tradeChoice) {
        ServerboundSelectTradePacket packet = new ServerboundSelectTradePacket(tradeChoice);
        session.sendDownstreamGamePacket(packet);
        if (session.isEmulatePost1_13Logic()) {
            container.onTradeSelected(session, tradeChoice);
            return this.translateRequest(session, container, request);
        }
        session.scheduleInEventLoop(() -> {
            Inventory patt8027$temp = session.getOpenInventory();
            if (patt8027$temp instanceof MerchantContainer) {
                MerchantContainer merchantInventory = (MerchantContainer)patt8027$temp;
                merchantInventory.onTradeSelected(session, tradeChoice);
                this.translateRequest(session, container, request);
                this.updateInventory(session, container);
                InventoryUtils.updateCursor(session);
            }
        }, 100L, TimeUnit.MILLISECONDS);
        return MerchantInventoryTranslator.rejectRequest(request);
    }

    @Override
    public void updateInventory(GeyserSession session, MerchantContainer container) {
        this.updater.updateInventory(this, session, container);
    }

    @Override
    public void updateSlot(GeyserSession session, MerchantContainer container, int slot) {
        this.updater.updateSlot(this, session, container, slot);
    }

    @Override
    public MerchantContainer createInventory(GeyserSession session, String name, int windowId, ContainerType containerType) {
        return new MerchantContainer(session, name, windowId, this.size, containerType);
    }
}

