/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.skin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.geysermc.floodgate.util.WebsocketEventType;
import org.geysermc.geyser.Constants;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.JsonUtils;
import org.geysermc.geyser.util.PluginMessageUtils;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public final class FloodgateSkinUploader {
    private static final int MAX_QUEUED_ENTRIES = 500;
    private final GeyserLogger logger;
    private final WebSocketClient client;
    private volatile boolean closed;
    private @MonotonicNonNull Deque<String> skinQueue = null;
    private int id;
    private String verifyCode;
    private int subscribersCount;

    public FloodgateSkinUploader(final GeyserImpl geyser) {
        this.logger = geyser.getLogger();
        this.client = new WebSocketClient(Constants.GLOBAL_API_WS_URI){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOpen(ServerHandshake handshake) {
                boolean hasSkinQueue;
                this.setConnectionLostTimeout(11);
                boolean bl = hasSkinQueue = FloodgateSkinUploader.this.skinQueue != null;
                if (!hasSkinQueue) {
                    FloodgateSkinUploader.this.skinQueue = new LinkedList<String>();
                    return;
                }
                Deque<String> deque = FloodgateSkinUploader.this.skinQueue;
                synchronized (deque) {
                    Iterator<String> queueIterator = FloodgateSkinUploader.this.skinQueue.iterator();
                    while (this.isOpen() && queueIterator.hasNext()) {
                        this.send(queueIterator.next());
                        queueIterator.remove();
                    }
                }
            }

            @Override
            public void onMessage(String message) {
                try {
                    JsonObject node = JsonUtils.parseJson(message);
                    if (node.has("error")) {
                        FloodgateSkinUploader.this.logger.error("Got an error: " + node.get("error").getAsString());
                        return;
                    }
                    int typeId = node.get("event_id").getAsInt();
                    WebsocketEventType type = WebsocketEventType.fromId(typeId);
                    if (type == null) {
                        FloodgateSkinUploader.this.logger.warning(String.format("Got (unknown) type %s. Ensure that Geyser is on the latest version and report this issue!", typeId));
                        return;
                    }
                    block1 : switch (type) {
                        case SUBSCRIBER_CREATED: {
                            FloodgateSkinUploader.this.id = node.get("id").getAsInt();
                            FloodgateSkinUploader.this.verifyCode = node.get("verify_code").getAsString();
                            break;
                        }
                        case SUBSCRIBER_COUNT: {
                            FloodgateSkinUploader.this.subscribersCount = node.get("subscribers_count").getAsInt();
                            break;
                        }
                        case SKIN_UPLOADED: {
                            String xuid;
                            GeyserSession session;
                            if (FloodgateSkinUploader.this.subscribersCount != 1 || (session = geyser.connectionByXuid(xuid = node.get("xuid").getAsString())) == null) break;
                            if (!node.get("success").getAsBoolean()) {
                                FloodgateSkinUploader.this.logger.info("Failed to upload skin for " + session.bedrockUsername());
                                return;
                            }
                            JsonObject data = node.getAsJsonObject("data");
                            String value = data.get("value").getAsString();
                            String signature = data.get("signature").getAsString();
                            byte[] bytes = (value + "\u0000" + signature).getBytes(StandardCharsets.UTF_8);
                            PluginMessageUtils.sendMessage(session, "floodgate:skin", bytes);
                            break;
                        }
                        case LOG_MESSAGE: {
                            String logMessage = node.get("message").getAsString();
                            switch (node.get("priority").getAsInt()) {
                                case -1: {
                                    FloodgateSkinUploader.this.logger.debug("Got a message from skin uploader: " + logMessage);
                                    break block1;
                                }
                                case 0: {
                                    FloodgateSkinUploader.this.logger.info("Got a message from skin uploader: " + logMessage);
                                    break block1;
                                }
                                case 1: {
                                    FloodgateSkinUploader.this.logger.error("Got a message from skin uploader: " + logMessage);
                                    break block1;
                                }
                            }
                            FloodgateSkinUploader.this.logger.info(logMessage);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    FloodgateSkinUploader.this.logger.error("Error while receiving a message", e);
                }
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                if (reason != null && !reason.isEmpty()) {
                    try {
                        JsonObject node = JsonUtils.parseJson(reason);
                        if (node.has("info")) {
                            String info = node.get("info").getAsString();
                            FloodgateSkinUploader.this.logger.debug("Got disconnected from the skin uploader: " + info);
                        }
                        if (node.has("error")) {
                            String error = node.get("error").getAsString();
                            FloodgateSkinUploader.this.logger.info("Got disconnected from the skin uploader: " + error);
                        }
                    }
                    catch (JsonSyntaxException node) {
                    }
                    catch (Exception e) {
                        FloodgateSkinUploader.this.logger.error("Error while handling onClose", e);
                    }
                }
                FloodgateSkinUploader.this.reconnectLater(geyser);
            }

            @Override
            public void onError(Exception ex) {
                if (ex instanceof UnknownHostException) {
                    FloodgateSkinUploader.this.logger.error("Unable to resolve the skin api! This can be caused by your connection or the skin api being unreachable. " + ex.getMessage());
                    return;
                }
                if (ex instanceof ConnectException || ex instanceof SSLException) {
                    if (FloodgateSkinUploader.this.logger.isDebug()) {
                        FloodgateSkinUploader.this.logger.error("[debug] Got an error", ex);
                    }
                    return;
                }
                FloodgateSkinUploader.this.logger.error("Got an error", ex);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadSkin(GeyserSession session) {
        List<String> chainData = session.getCertChainData();
        String token = session.getToken();
        String clientData = session.getClientData().getOriginalString();
        if (chainData == null && token == null || clientData == null) {
            return;
        }
        JsonObject node = new JsonObject();
        if (chainData != null) {
            JsonArray chainDataNode = new JsonArray();
            chainData.forEach(arg_0 -> ((JsonArray)chainDataNode).add(arg_0));
            node.add("chain_data", (JsonElement)chainDataNode);
        } else {
            node.addProperty("token", token);
        }
        node.addProperty("client_data", clientData);
        String jsonString = node.toString();
        if (this.client.isOpen()) {
            this.client.send(jsonString);
            return;
        }
        if (this.skinQueue != null) {
            Deque<String> deque = this.skinQueue;
            synchronized (deque) {
                if (this.skinQueue.size() >= 500) {
                    this.skinQueue.removeFirst();
                }
                this.skinQueue.addLast(jsonString);
            }
        }
    }

    private void reconnectLater(GeyserImpl geyser) {
        if (geyser.getScheduledThread().isShutdown() || this.closed) {
            this.logger.info("The skin uploader has been closed");
            return;
        }
        long additionalTime = ThreadLocalRandom.current().nextInt(7);
        geyser.getScheduledThread().schedule(this.client::reconnect, 8L + additionalTime, TimeUnit.SECONDS);
    }

    public FloodgateSkinUploader start() {
        this.client.connect();
        return this;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.client.close();
        }
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getVerifyCode() {
        return this.verifyCode;
    }

    @Generated
    public int getSubscribersCount() {
        return this.subscribersCount;
    }
}

