/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.type;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import lombok.Generated;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.api.block.custom.CustomBlockPermutation;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.api.block.custom.component.BoxComponent;
import org.geysermc.geyser.api.block.custom.component.CustomBlockComponents;
import org.geysermc.geyser.api.block.custom.component.TransformationComponent;
import org.geysermc.geyser.level.block.GeyserCustomBlockComponents;
import org.geysermc.geyser.level.block.GeyserCustomBlockData;
import org.geysermc.geyser.level.block.GeyserGeometryComponent;
import org.geysermc.geyser.level.block.GeyserMaterialInstance;

public class CustomSkull {
    private final String skinHash;
    private CustomBlockData customBlockData;
    private static final String BITS_A_PROPERTY = "geyser_skull:bits_a";
    private static final String BITS_B_PROPERTY = "geyser_skull:bits_b";
    private static final int[] ROTATIONS = new int[]{0, -90, 180, 90};
    private static final BoxComponent FLOOR_BOX = new BoxComponent(-4.0f, 0.0f, -4.0f, 8.0f, 8.0f, 8.0f);
    private static final BoxComponent WALL_BOX = new BoxComponent(-4.0f, 4.0f, 0.0f, 8.0f, 8.0f, 8.0f);

    public CustomSkull(String skinHash) {
        this.skinHash = skinHash;
        CustomBlockComponents components = new GeyserCustomBlockComponents.Builder().destructibleByMining(Float.valueOf(1.5f)).materialInstance("*", new GeyserMaterialInstance.Builder().texture("geyser." + skinHash + "_player_skin").renderMethod("alpha_test").faceDimming(true).ambientOcclusion(true).build()).lightDampening(0).placeAir(true).build();
        ArrayList<CustomBlockPermutation> permutations = new ArrayList<CustomBlockPermutation>();
        this.addDefaultPermutation(permutations);
        this.addFloorPermutations(permutations);
        this.addWallPermutations(permutations);
        this.customBlockData = ((GeyserCustomBlockData.Builder)((GeyserCustomBlockData.Builder)((GeyserCustomBlockData.Builder)new GeyserCustomBlockData.Builder().name("player_skull_" + skinHash).components(components).intProperty(BITS_A_PROPERTY, (List)IntStream.rangeClosed(0, 6).boxed().toList())).intProperty(BITS_B_PROPERTY, (List)IntStream.rangeClosed(0, 2).boxed().toList())).permutations(permutations)).build();
    }

    public CustomBlockState getWallBlockState(int wallDirection) {
        wallDirection = switch (wallDirection) {
            case 0 -> 2;
            case 90 -> 3;
            case 180 -> 0;
            case 270 -> 1;
            default -> throw new IllegalArgumentException("Unknown skull wall direction: " + wallDirection);
        };
        return this.customBlockData.blockStateBuilder().intProperty(BITS_A_PROPERTY, wallDirection + 1).intProperty(BITS_B_PROPERTY, 0).build();
    }

    public CustomBlockState getFloorBlockState(int floorRotation) {
        return this.customBlockData.blockStateBuilder().intProperty(BITS_A_PROPERTY, (5 + floorRotation) % 7).intProperty(BITS_B_PROPERTY, (5 + floorRotation) / 7).build();
    }

    private void addDefaultPermutation(List<CustomBlockPermutation> permutations) {
        CustomBlockComponents components = new GeyserCustomBlockComponents.Builder().geometry(new GeyserGeometryComponent.Builder().identifier("geometry.geyser.player_skull_hand").build()).transformation(new TransformationComponent(0, 180, 0)).build();
        String condition = String.format("query.block_property('%s') == 0 && query.block_property('%s') == 0", BITS_A_PROPERTY, BITS_B_PROPERTY);
        permutations.add(new CustomBlockPermutation(components, condition));
    }

    private void addFloorPermutations(List<CustomBlockPermutation> permutations) {
        String[] quadrantNames = new String[]{"a", "b", "c", "d"};
        for (int quadrant = 0; quadrant < 4; ++quadrant) {
            for (int i = 0; i < 4; ++i) {
                int floorRotation = 4 * quadrant + i;
                CustomBlockComponents components = new GeyserCustomBlockComponents.Builder().selectionBox(FLOOR_BOX).collisionBox(FLOOR_BOX).geometry(new GeyserGeometryComponent.Builder().identifier("geometry.geyser.player_skull_floor_" + quadrantNames[i]).build()).transformation(new TransformationComponent(0, ROTATIONS[quadrant], 0)).build();
                int bitsA = (5 + floorRotation) % 7;
                int bitsB = (5 + floorRotation) / 7;
                String condition = String.format("query.block_property('%s') == %d && query.block_property('%s') == %d", BITS_A_PROPERTY, bitsA, BITS_B_PROPERTY, bitsB);
                permutations.add(new CustomBlockPermutation(components, condition));
            }
        }
    }

    private void addWallPermutations(List<CustomBlockPermutation> permutations) {
        for (int i = 0; i < 4; ++i) {
            CustomBlockComponents components = new GeyserCustomBlockComponents.Builder().selectionBox(WALL_BOX).collisionBox(WALL_BOX).geometry(new GeyserGeometryComponent.Builder().identifier("geometry.geyser.player_skull_wall").build()).transformation(new TransformationComponent(0, ROTATIONS[i], 0)).build();
            String condition = String.format("query.block_property('%s') == %d && query.block_property('%s') == %d", BITS_A_PROPERTY, i + 1, BITS_B_PROPERTY, 0);
            permutations.add(new CustomBlockPermutation(components, condition));
        }
    }

    @Generated
    public String getSkinHash() {
        return this.skinHash;
    }

    @Generated
    public CustomBlockData getCustomBlockData() {
        return this.customBlockData;
    }

    @Generated
    public void setCustomBlockData(CustomBlockData customBlockData) {
        this.customBlockData = customBlockData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomSkull)) {
            return false;
        }
        CustomSkull other = (CustomSkull)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$skinHash = this.getSkinHash();
        String other$skinHash = other.getSkinHash();
        if (this$skinHash == null ? other$skinHash != null : !this$skinHash.equals(other$skinHash)) {
            return false;
        }
        CustomBlockData this$customBlockData = this.getCustomBlockData();
        CustomBlockData other$customBlockData = other.getCustomBlockData();
        return !(this$customBlockData == null ? other$customBlockData != null : !this$customBlockData.equals(other$customBlockData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CustomSkull;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $skinHash = this.getSkinHash();
        result = result * 59 + ($skinHash == null ? 43 : $skinHash.hashCode());
        CustomBlockData $customBlockData = this.getCustomBlockData();
        result = result * 59 + ($customBlockData == null ? 43 : $customBlockData.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CustomSkull(skinHash=" + this.getSkinHash() + ", customBlockData=" + String.valueOf(this.getCustomBlockData()) + ")";
    }
}

