/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.registry.Registry;
import org.geysermc.geyser.registry.loader.RegistryLoader;

public abstract class AbstractMappedRegistry<K, V, M extends Map<K, V>>
extends Registry<M> {
    protected <I> AbstractMappedRegistry(I input, RegistryLoader<I, M> registryLoader) {
        super(input, registryLoader);
    }

    public @Nullable V get(K key) {
        return ((Map)this.mappings).get(key);
    }

    public <U> Optional<U> map(K key, Function<? super V, ? extends U> mapper) {
        V value = this.get(key);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(value));
    }

    public V getOrDefault(K key, V defaultValue) {
        return ((Map)this.mappings).getOrDefault(key, defaultValue);
    }

    public V register(K key, V value) {
        return ((Map)this.mappings).put(key, value);
    }
}

