/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.velocity;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.lang.reflect.Method;
import org.geysermc.geyser.GeyserImpl;

public class GeyserVelocityCompressionDisabler
extends ChannelDuplexHandler {
    static final boolean ENABLED;
    private static final Class<?> COMPRESSION_PACKET_CLASS;
    private static final Class<?> LOGIN_SUCCESS_PACKET_CLASS;
    private static final Object COMPRESSION_ENABLED_EVENT;
    private static final Method SET_COMPRESSION_METHOD;

    public GeyserVelocityCompressionDisabler() {
        if (!ENABLED) {
            throw new RuntimeException("Geyser compression disabler cannot be initialized in its current state!");
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        Class<?> msgClass = msg.getClass();
        if (!COMPRESSION_PACKET_CLASS.isAssignableFrom(msgClass)) {
            if (LOGIN_SUCCESS_PACKET_CLASS.isAssignableFrom(msgClass)) {
                ctx.pipeline().remove((ChannelHandler)this);
            }
            super.write(ctx, msg, promise);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt != COMPRESSION_ENABLED_EVENT) {
            super.userEventTriggered(ctx, evt);
            return;
        }
        ChannelHandler minecraftConnection = ctx.pipeline().get("handler");
        SET_COMPRESSION_METHOD.invoke((Object)minecraftConnection, -1);
    }

    static {
        boolean enabled = false;
        Class<?> compressionPacketClass = null;
        Class<?> loginSuccessPacketClass = null;
        Object compressionEnabledEvent = null;
        Method setCompressionMethod = null;
        try {
            try {
                compressionPacketClass = Class.forName("com.velocitypowered.proxy.protocol.packet.SetCompressionPacket");
                loginSuccessPacketClass = Class.forName("com.velocitypowered.proxy.protocol.packet.ServerLoginSuccessPacket");
            }
            catch (Exception ignored) {
                compressionPacketClass = Class.forName("com.velocitypowered.proxy.protocol.packet.SetCompression");
                loginSuccessPacketClass = Class.forName("com.velocitypowered.proxy.protocol.packet.ServerLoginSuccess");
            }
            compressionEnabledEvent = Class.forName("com.velocitypowered.proxy.protocol.VelocityConnectionEvent").getDeclaredField("COMPRESSION_ENABLED").get(null);
            setCompressionMethod = Class.forName("com.velocitypowered.proxy.connection.MinecraftConnection").getMethod("setCompressionThreshold", Integer.TYPE);
            enabled = true;
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().error("Could not initialize compression disabler!", e);
        }
        ENABLED = enabled;
        COMPRESSION_PACKET_CLASS = compressionPacketClass;
        LOGIN_SUCCESS_PACKET_CLASS = loginSuccessPacketClass;
        COMPRESSION_ENABLED_EVENT = compressionEnabledEvent;
        SET_COMPRESSION_METHOD = setCompressionMethod;
    }
}

