/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.impl.entity;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.api.entity.data.GeyserEntityDataType;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;

public class GeyserEntityDataImpl<T>
implements GeyserEntityDataType<T> {
    public static Map<String, GeyserEntityDataImpl<?>> TYPES = new Object2ObjectOpenHashMap();
    private final Class<T> typeClass;
    private final String name;
    private final BiConsumer<Entity, T> consumer;
    private final Function<Entity, T> getter;

    public static GeyserEntityDataImpl<?> lookup(Class<?> clazz, String name) {
        GeyserEntityDataImpl<?> type = TYPES.get(name);
        if (type == null) {
            throw new IllegalArgumentException("Unknown entity data type: " + name);
        }
        if (type.typeClass == clazz) {
            return TYPES.get(name);
        }
        throw new IllegalArgumentException("Unknown entity data type: " + name);
    }

    public GeyserEntityDataImpl(Class<T> typeClass, String name, EntityDataType<T> type) {
        this.typeClass = typeClass;
        this.name = name;
        this.consumer = (entity, data) -> entity.getDirtyMetadata().put(type, data);
        this.getter = entity -> {
            Object value = entity.getMetadata().get(type);
            if (typeClass.isInstance(value)) {
                return typeClass.cast(value);
            }
            return null;
        };
    }

    public GeyserEntityDataImpl(Class<T> typeClass, String name, EntityFlag flag) {
        this.typeClass = typeClass;
        this.name = name;
        this.consumer = (entity, data) -> {
            if (!(data instanceof Boolean)) {
                throw new RuntimeException("Invalid data type: " + data.getClass().getName());
            }
            Boolean bool = (Boolean)data;
            entity.setFlag(flag, bool);
        };
        this.getter = entity -> typeClass.cast(entity.getFlag(flag));
    }

    @Override
    public @NonNull Class<T> typeClass() {
        return this.typeClass;
    }

    @Override
    public @NonNull String name() {
        return this.name;
    }

    public void update(Entity entity, T value) {
        this.consumer.accept(entity, (Entity)value);
    }

    public T value(Entity entity) {
        return this.getter.apply(entity);
    }

    @Generated
    public GeyserEntityDataImpl(Class<T> typeClass, String name, BiConsumer<Entity, T> consumer, Function<Entity, T> getter) {
        this.typeClass = typeClass;
        this.name = name;
        this.consumer = consumer;
        this.getter = getter;
    }

    static {
        TYPES.put("color", new GeyserEntityDataImpl<Byte>(Byte.class, "color", EntityDataTypes.COLOR));
        TYPES.put("variant", new GeyserEntityDataImpl<Integer>(Integer.class, "variant", EntityDataTypes.VARIANT));
        TYPES.put("width", new GeyserEntityDataImpl<Float>(Float.class, "width", EntityDataTypes.WIDTH));
        TYPES.put("height", new GeyserEntityDataImpl<Float>(Float.class, "height", EntityDataTypes.HEIGHT));
        TYPES.put("scale", new GeyserEntityDataImpl<Float>(Float.class, "scale", EntityDataTypes.SCALE));
        TYPES.put("vertical_offset", new GeyserEntityDataImpl<Float>(Float.class, "offset", (entity, value) -> entity.offset(value.floatValue(), true), Entity::getOffset));
    }
}

