/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.LevelSoundEventPacket;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.monster.MonsterEntity;
import org.geysermc.geyser.registry.type.GeyserBedrockBlock;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;

public class EndermanEntity
extends MonsterEntity {
    public EndermanEntity(EntitySpawnContext context) {
        super(context);
    }

    public void setCarriedBlock(IntEntityMetadata entityMetadata) {
        GeyserBedrockBlock bedrockBlockId = this.session.getBlockMappings().getBedrockBlock(entityMetadata.getPrimitiveValue());
        this.dirtyMetadata.put(EntityDataTypes.CARRY_BLOCK_STATE, bedrockBlockId);
    }

    public void setScreaming(BooleanEntityMetadata entityMetadata) {
        if (entityMetadata.getPrimitiveValue()) {
            LevelSoundEventPacket packet = new LevelSoundEventPacket();
            packet.setSound(SoundEvent.STARE);
            packet.setPosition(this.bedrockPosition());
            packet.setExtraData(-1);
            packet.setIdentifier("minecraft:enderman");
            this.session.sendUpstreamPacket(packet);
        }
    }

    public void setAngry(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.ANGRY, entityMetadata.getPrimitiveValue());
    }
}

