/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.spawn;

import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Consumer;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.common.util.TriFunction;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.entity.definition.GeyserEntityDefinition;
import org.geysermc.geyser.api.entity.definition.JavaEntityType;
import org.geysermc.geyser.api.entity.type.GeyserEntity;
import org.geysermc.geyser.api.entity.type.player.GeyserPlayerEntity;
import org.geysermc.geyser.api.event.java.ServerAttachParrotsEvent;
import org.geysermc.geyser.api.event.java.ServerSpawnEntityEvent;
import org.geysermc.geyser.entity.BedrockEntityDefinition;
import org.geysermc.geyser.entity.EntityTypeDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.EnvironmentUtils;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundAddEntityPacket;

public class EntitySpawnContext {
    private final GeyserSession session;
    private final EntityTypeDefinition<?> entityTypeDefinition;
    private int javaId;
    private final UUID uuid;
    private BedrockEntityDefinition bedrockEntityDefinition;
    private Vector3f position;
    private Vector3f motion;
    private float yaw;
    private float pitch;
    private float headYaw;
    private float height;
    private float width;
    private float offset;
    private @Nullable Long geyserId;
    private @Nullable Collection<Consumer<GeyserEntity>> consumers;
    public static final TriFunction<GeyserSession, UUID, EntityTypeDefinition<?>, EntitySpawnContext> DUMMY_CONTEXT = (session, uuid, definition) -> new EntitySpawnContext((GeyserSession)session, (EntityTypeDefinition<?>)definition, 0, (UUID)uuid);

    public EntitySpawnContext(GeyserSession session, EntityTypeDefinition<?> type, int javaId, UUID uuid) {
        this(session, type, javaId, uuid, type.defaultBedrockDefinition(), Vector3f.ZERO, Vector3f.ZERO, 0.0f, 0.0f, 0.0f, type.height(), type.width(), type.offset(), null);
    }

    public EntitySpawnContext(GeyserSession session, EntityTypeDefinition<?> type, int entityId, float height, float width, long geyserId) {
        this(session, type, entityId, null, type.defaultBedrockDefinition(), Vector3f.ZERO, Vector3f.ZERO, 0.0f, 0.0f, 0.0f, height, width, 0.0f, geyserId);
    }

    public static EntitySpawnContext fromPacket(GeyserSession session, EntityTypeDefinition<?> definition, ClientboundAddEntityPacket packet) {
        Vector3f position = Vector3f.from(packet.getX(), packet.getY(), packet.getZ());
        Vector3f motion = packet.getMovement().toFloat();
        return new EntitySpawnContext(session, definition, packet.getEntityId(), packet.getUuid(), definition.defaultBedrockDefinition(), position, motion, packet.getYaw(), packet.getPitch(), packet.getHeadYaw(), definition.height(), definition.width(), definition.offset(), null);
    }

    public static EntitySpawnContext inherited(GeyserSession session, EntityTypeDefinition<?> definition, Entity base, Vector3f position) {
        return new EntitySpawnContext(session, definition, 0, null, definition.defaultBedrockDefinition(), position, base.getMotion(), base.getYaw(), base.getPitch(), base.getHeadYaw(), definition.height(), definition.width(), definition.offset(), null);
    }

    public EntitySpawnContext(GeyserSession session, EntityTypeDefinition<?> definition, int javaId, UUID uuid, BedrockEntityDefinition bedrockEntityDefinition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw, float height, float width, float offset, @Nullable Long geyserId) {
        this.session = session;
        this.entityTypeDefinition = definition;
        this.javaId = javaId;
        this.uuid = uuid;
        this.bedrockEntityDefinition = bedrockEntityDefinition;
        this.position = position;
        this.motion = motion;
        this.yaw = yaw;
        this.pitch = pitch;
        this.headYaw = headYaw;
        this.height = height;
        this.width = width;
        this.offset = offset;
        this.geyserId = geyserId;
        this.consumers = null;
    }

    public boolean callServerSpawnEvent() {
        if (EnvironmentUtils.IS_UNIT_TESTING) {
            return true;
        }
        GeyserImpl.getInstance().getEventBus().fire(new ServerSpawnEntityEvent(this.session){

            @Override
            public boolean isCancelled() {
                return EntitySpawnContext.this.bedrockEntityDefinition == null;
            }

            @Override
            public void setCancelled(boolean cancelled) {
                EntitySpawnContext.this.bedrockEntityDefinition = null;
            }

            @Override
            public int entityId() {
                return EntitySpawnContext.this.javaId;
            }

            @Override
            public @NonNull UUID uuid() {
                return EntitySpawnContext.this.uuid;
            }

            @Override
            public @NonNull JavaEntityType entityType() {
                return EntitySpawnContext.this.entityTypeDefinition.type();
            }

            @Override
            public @Nullable GeyserEntityDefinition definition() {
                return EntitySpawnContext.this.bedrockEntityDefinition;
            }

            @Override
            public void definition(@Nullable GeyserEntityDefinition entityDefinition) {
                if (entityDefinition == null) {
                    EntitySpawnContext.this.bedrockEntityDefinition = null;
                    return;
                }
                if (!(entityDefinition instanceof BedrockEntityDefinition)) {
                    throw new IllegalStateException("Unknown implementation of GeyserEntityDefinition! Got: " + entityDefinition.getClass().getSimpleName());
                }
                BedrockEntityDefinition definition = (BedrockEntityDefinition)entityDefinition;
                if (!entityDefinition.registered()) {
                    throw new IllegalStateException("%s is not registered!".formatted(entityDefinition.identifier()));
                }
                EntitySpawnContext.this.bedrockEntityDefinition = definition;
            }

            @Override
            public void preSpawnConsumer(Consumer<@NonNull GeyserEntity> consumer) {
                if (EntitySpawnContext.this.consumers == null) {
                    EntitySpawnContext.this.consumers = new HashSet<Consumer<GeyserEntity>>();
                }
                EntitySpawnContext.this.consumers.add(consumer);
            }
        });
        return this.bedrockEntityDefinition != null;
    }

    public boolean callParrotEvent(final PlayerEntity player, final int variant, final boolean right) {
        GeyserImpl.getInstance().eventBus().fire(new ServerAttachParrotsEvent(this.session){

            @Override
            public GeyserPlayerEntity player() {
                return player;
            }

            @Override
            public int variant() {
                return variant;
            }

            @Override
            public boolean right() {
                return right;
            }

            @Override
            public @Nullable GeyserEntityDefinition definition() {
                return EntitySpawnContext.this.bedrockEntityDefinition;
            }

            @Override
            public void definition(@Nullable GeyserEntityDefinition entityDefinition) {
                if (entityDefinition == null) {
                    EntitySpawnContext.this.bedrockEntityDefinition = null;
                    return;
                }
                if (!(entityDefinition instanceof BedrockEntityDefinition)) {
                    throw new IllegalStateException("Unknown implementation of GeyserEntityDefinition! Got: " + entityDefinition.getClass().getSimpleName());
                }
                BedrockEntityDefinition definition = (BedrockEntityDefinition)entityDefinition;
                if (!entityDefinition.registered()) {
                    throw new IllegalStateException("%s is not registered!".formatted(entityDefinition.identifier()));
                }
                EntitySpawnContext.this.bedrockEntityDefinition = definition;
            }

            @Override
            public boolean isCancelled() {
                return EntitySpawnContext.this.bedrockEntityDefinition == null;
            }

            @Override
            public void setCancelled(boolean cancelled) {
                EntitySpawnContext.this.bedrockEntityDefinition = null;
            }

            @Override
            public void preSpawnConsumer(Consumer<@NonNull GeyserEntity> consumer) {
                if (EntitySpawnContext.this.consumers == null) {
                    EntitySpawnContext.this.consumers = new HashSet<Consumer<GeyserEntity>>();
                }
                EntitySpawnContext.this.consumers.add(consumer);
            }
        });
        return this.bedrockEntityDefinition == null;
    }

    public long geyserId() {
        if (this.geyserId == null) {
            this.geyserId = this.session.getEntityCache().getNextEntityId().incrementAndGet();
            return this.geyserId;
        }
        return this.geyserId;
    }

    @Generated
    public GeyserSession session() {
        return this.session;
    }

    @Generated
    public EntityTypeDefinition<?> entityTypeDefinition() {
        return this.entityTypeDefinition;
    }

    @Generated
    public int javaId() {
        return this.javaId;
    }

    @Generated
    public UUID uuid() {
        return this.uuid;
    }

    @Generated
    public BedrockEntityDefinition bedrockEntityDefinition() {
        return this.bedrockEntityDefinition;
    }

    @Generated
    public Vector3f position() {
        return this.position;
    }

    @Generated
    public Vector3f motion() {
        return this.motion;
    }

    @Generated
    public float yaw() {
        return this.yaw;
    }

    @Generated
    public float pitch() {
        return this.pitch;
    }

    @Generated
    public float headYaw() {
        return this.headYaw;
    }

    @Generated
    public float height() {
        return this.height;
    }

    @Generated
    public float width() {
        return this.width;
    }

    @Generated
    public float offset() {
        return this.offset;
    }

    @Generated
    public @Nullable Collection<Consumer<GeyserEntity>> consumers() {
        return this.consumers;
    }

    @Generated
    public EntitySpawnContext javaId(int javaId) {
        this.javaId = javaId;
        return this;
    }

    @Generated
    public EntitySpawnContext bedrockEntityDefinition(BedrockEntityDefinition bedrockEntityDefinition) {
        this.bedrockEntityDefinition = bedrockEntityDefinition;
        return this;
    }

    @Generated
    public EntitySpawnContext position(Vector3f position) {
        this.position = position;
        return this;
    }

    @Generated
    public EntitySpawnContext motion(Vector3f motion) {
        this.motion = motion;
        return this;
    }

    @Generated
    public EntitySpawnContext yaw(float yaw) {
        this.yaw = yaw;
        return this;
    }

    @Generated
    public EntitySpawnContext pitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    @Generated
    public EntitySpawnContext headYaw(float headYaw) {
        this.headYaw = headYaw;
        return this;
    }

    @Generated
    public EntitySpawnContext height(float height) {
        this.height = height;
        return this;
    }

    @Generated
    public EntitySpawnContext width(float width) {
        this.width = width;
        return this;
    }

    @Generated
    public EntitySpawnContext offset(float offset) {
        this.offset = offset;
        return this;
    }

    @Generated
    public EntitySpawnContext geyserId(@Nullable Long geyserId) {
        this.geyserId = geyserId;
        return this;
    }

    @Generated
    public EntitySpawnContext consumers(@Nullable Collection<Consumer<GeyserEntity>> consumers) {
        this.consumers = consumers;
        return this;
    }
}

