/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.vector;

import java.util.Iterator;
import org.cloudburstmc.math.MathImplementationLoader;
import org.cloudburstmc.math.vector.Vector2d;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector2i;
import org.cloudburstmc.math.vector.Vector2l;
import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.math.vector.Vector3l;
import org.cloudburstmc.math.vector.Vector4d;
import org.cloudburstmc.math.vector.Vector4f;
import org.cloudburstmc.math.vector.Vector4i;
import org.cloudburstmc.math.vector.Vector4l;
import org.cloudburstmc.math.vector.VectorProvider;

class Vectors {
    private static VectorProvider cached;

    Vectors() {
    }

    public static VectorProvider provider() {
        if (cached != null) {
            return cached;
        }
        Iterator<VectorProvider> iterator = MathImplementationLoader.serviceLoader(VectorProvider.class).iterator();
        if (!iterator.hasNext()) {
            throw new RuntimeException("Could not initialize vector provider as no implementation was provided!");
        }
        cached = iterator.next();
        return cached;
    }

    public static Vector2d createVector2d(double x, double y) {
        return Vectors.provider().createVector2d(x, y);
    }

    public static Vector2f createVector2f(float x, float y) {
        return Vectors.provider().createVector2f(x, y);
    }

    public static Vector2i createVector2i(int x, int y) {
        return Vectors.provider().createVector2i(x, y);
    }

    public static Vector2l createVector2l(long x, long y) {
        return Vectors.provider().createVector2l(x, y);
    }

    public static Vector3d createVector3d(double x, double y, double z) {
        return Vectors.provider().createVector3d(x, y, z);
    }

    public static Vector3f createVector3f(float x, float y, float z) {
        return Vectors.provider().createVector3f(x, y, z);
    }

    public static Vector3i createVector3i(int x, int y, int z) {
        return Vectors.provider().createVector3i(x, y, z);
    }

    public static Vector3l createVector3l(long x, long y, long z) {
        return Vectors.provider().createVector3l(x, y, z);
    }

    public static Vector4d createVector4d(double x, double y, double z, double w) {
        return Vectors.provider().createVector4d(x, y, z, w);
    }

    public static Vector4f createVector4f(float x, float y, float z, float w) {
        return Vectors.provider().createVector4f(x, y, z, w);
    }

    public static Vector4i createVector4i(int x, int y, int z, int w) {
        return Vectors.provider().createVector4i(x, y, z, w);
    }

    public static Vector4l createVector4l(long x, long y, long z, long w) {
        return Vectors.provider().createVector4l(x, y, z, w);
    }
}

