/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.vector;

import java.io.Serializable;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.math.vector.Vector3l;
import org.cloudburstmc.math.vector.Vector4f;
import org.cloudburstmc.math.vector.VectorNf;
import org.cloudburstmc.math.vector.Vectorf;
import org.cloudburstmc.math.vector.Vectors;

@ParametersAreNonnullByDefault
@Immutable
public abstract class Vector3f
implements Vectorf,
Comparable<Vector3f>,
Serializable,
Cloneable {
    public static final Vector3f ZERO = Vector3f.from(0.0f, 0.0f, 0.0f);
    public static final Vector3f UNIT_X = Vector3f.from(1.0f, 0.0f, 0.0f);
    public static final Vector3f UNIT_Y = Vector3f.from(0.0f, 1.0f, 0.0f);
    public static final Vector3f UNIT_Z = Vector3f.from(0.0f, 0.0f, 1.0f);
    public static final Vector3f ONE = Vector3f.from(1.0f, 1.0f, 1.0f);
    public static final Vector3f RIGHT = UNIT_X;
    public static final Vector3f UP = UNIT_Y;
    public static final Vector3f FORWARD = UNIT_Z;

    public abstract float getX();

    public abstract float getY();

    public abstract float getZ();

    public int getFloorX() {
        return GenericMath.floor(this.getX());
    }

    public int getFloorY() {
        return GenericMath.floor(this.getY());
    }

    public int getFloorZ() {
        return GenericMath.floor(this.getZ());
    }

    @Nonnull
    public Vector3f add(Vector3f v) {
        return this.add(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3f add(double x, double y, double z) {
        return this.add((float)x, (float)y, (float)z);
    }

    @Nonnull
    public abstract Vector3f add(float var1, float var2, float var3);

    @Nonnull
    public Vector3f sub(Vector3f v) {
        return this.sub(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3f sub(double x, double y, double z) {
        return this.sub((float)x, (float)y, (float)z);
    }

    @Nonnull
    public abstract Vector3f sub(float var1, float var2, float var3);

    @Nonnull
    public Vector3f mul(double a) {
        return this.mul((float)a);
    }

    @Override
    @Nonnull
    public Vector3f mul(float a) {
        return this.mul(a, a, a);
    }

    @Nonnull
    public Vector3f mul(Vector3f v) {
        return this.mul(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3f mul(double x, double y, double z) {
        return this.mul((float)x, (float)y, (float)z);
    }

    @Nonnull
    public abstract Vector3f mul(float var1, float var2, float var3);

    @Nonnull
    public Vector3f div(double a) {
        return this.div((float)a);
    }

    @Override
    @Nonnull
    public Vector3f div(float a) {
        return this.div(a, a, a);
    }

    @Nonnull
    public Vector3f div(Vector3f v) {
        return this.div(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3f div(double x, double y, double z) {
        return this.div((float)x, (float)y, (float)z);
    }

    @Nonnull
    public abstract Vector3f div(float var1, float var2, float var3);

    public float dot(Vector3f v) {
        return this.dot(v.getX(), v.getY(), v.getZ());
    }

    public float dot(double x, double y, double z) {
        return this.dot((float)x, (float)y, (float)z);
    }

    public float dot(float x, float y, float z) {
        return this.getX() * x + this.getY() * y + this.getZ() * z;
    }

    @Nonnull
    public Vector3f project(Vector3f v) {
        return this.project(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3f project(double x, double y, double z) {
        return this.project((float)x, (float)y, (float)z);
    }

    @Nonnull
    public abstract Vector3f project(float var1, float var2, float var3);

    @Nonnull
    public Vector3f cross(Vector3f v) {
        return this.cross(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3f cross(double x, double y, double z) {
        return this.cross((float)x, (float)y, (float)z);
    }

    @Nonnull
    public abstract Vector3f cross(float var1, float var2, float var3);

    @Nonnull
    public Vector3f pow(double pow) {
        return this.pow((float)pow);
    }

    @Override
    @Nonnull
    public abstract Vector3f pow(float var1);

    @Override
    @Nonnull
    public abstract Vector3f ceil();

    @Override
    @Nonnull
    public abstract Vector3f floor();

    @Override
    @Nonnull
    public abstract Vector3f round();

    @Override
    @Nonnull
    public abstract Vector3f abs();

    @Override
    @Nonnull
    public abstract Vector3f negate();

    @Nonnull
    public Vector3f min(Vector3f v) {
        return this.min(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3f min(double x, double y, double z) {
        return this.min((float)x, (float)y, (float)z);
    }

    @Nonnull
    public abstract Vector3f min(float var1, float var2, float var3);

    @Nonnull
    public Vector3f max(Vector3f v) {
        return this.max(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3f max(double x, double y, double z) {
        return this.max((float)x, (float)y, (float)z);
    }

    @Nonnull
    public abstract Vector3f max(float var1, float var2, float var3);

    public float distanceSquared(Vector3f v) {
        return this.distanceSquared(v.getX(), v.getY(), v.getZ());
    }

    public float distanceSquared(double x, double y, double z) {
        return this.distanceSquared((float)x, (float)y, (float)z);
    }

    public float distanceSquared(float x, float y, float z) {
        float dx = this.getX() - x;
        float dy = this.getY() - y;
        float dz = this.getZ() - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public float distance(Vector3f v) {
        return this.distance(v.getX(), v.getY(), v.getZ());
    }

    public float distance(double x, double y, double z) {
        return this.distance((float)x, (float)y, (float)z);
    }

    public float distance(float x, float y, float z) {
        return (float)Math.sqrt(this.distanceSquared(x, y, z));
    }

    @Nonnull
    public Vector3f up() {
        return this.up(1.0f);
    }

    @Nonnull
    public abstract Vector3f up(float var1);

    @Nonnull
    public Vector3f down() {
        return this.down(1.0f);
    }

    @Nonnull
    public abstract Vector3f down(float var1);

    @Nonnull
    public Vector3f north() {
        return this.north(1.0f);
    }

    @Nonnull
    public abstract Vector3f north(float var1);

    @Nonnull
    public Vector3f south() {
        return this.south(1.0f);
    }

    @Nonnull
    public abstract Vector3f south(float var1);

    @Nonnull
    public Vector3f east() {
        return this.east(1.0f);
    }

    @Nonnull
    public abstract Vector3f east(float var1);

    @Nonnull
    public Vector3f west() {
        return this.west(1.0f);
    }

    @Nonnull
    public abstract Vector3f west(float var1);

    @Override
    public float lengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ();
    }

    @Override
    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    @Override
    @Nonnull
    public abstract Vector3f normalize();

    @Override
    public int getMinAxis() {
        return this.getX() < this.getY() ? (this.getX() < this.getZ() ? 0 : 2) : (this.getY() < this.getZ() ? 1 : 2);
    }

    @Override
    public int getMaxAxis() {
        return this.getX() < this.getY() ? (this.getY() < this.getZ() ? 2 : 1) : (this.getX() < this.getZ() ? 2 : 0);
    }

    @Nonnull
    public Vector2f toVector2() {
        return Vector2f.from(this);
    }

    @Nonnull
    public Vector2f toVector2(boolean useZ) {
        return Vector2f.from(this.getX(), useZ ? this.getZ() : this.getY());
    }

    @Nonnull
    public Vector4f toVector4() {
        return this.toVector4(0.0f);
    }

    @Nonnull
    public Vector4f toVector4(double w) {
        return this.toVector4((float)w);
    }

    @Nonnull
    public Vector4f toVector4(float w) {
        return Vector4f.from(this, w);
    }

    @Nonnull
    public VectorNf toVectorN() {
        return VectorNf.from(this);
    }

    @Override
    @Nonnull
    public float[] toArray() {
        return new float[]{this.getX(), this.getY(), this.getZ()};
    }

    @Override
    @Nonnull
    public Vector3i toInt() {
        return Vector3i.from(this.getX(), this.getY(), this.getZ());
    }

    @Override
    @Nonnull
    public Vector3l toLong() {
        return Vector3l.from(this.getX(), this.getY(), this.getZ());
    }

    @Override
    @Nonnull
    public Vector3f toFloat() {
        return Vector3f.from(this.getX(), this.getY(), this.getZ());
    }

    @Override
    @Nonnull
    public Vector3d toDouble() {
        return Vector3d.from(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public int compareTo(Vector3f v) {
        return (int)Math.signum(this.lengthSquared() - v.lengthSquared());
    }

    @Nonnull
    public Vector3f clone() {
        return Vector3f.from(this);
    }

    @Nonnull
    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")";
    }

    @Nonnull
    public static Vector3f from(float n) {
        return Vectors.createVector3f(n, n, n);
    }

    @Nonnull
    public static Vector3f from(Vector2f v) {
        return Vector3f.from(v, 0.0f);
    }

    @Nonnull
    public static Vector3f from(Vector2f v, double z) {
        return Vector3f.from(v, (float)z);
    }

    @Nonnull
    public static Vector3f from(Vector2f v, float z) {
        return Vector3f.from(v.getX(), v.getY(), z);
    }

    @Nonnull
    public static Vector3f from(Vector3f v) {
        return Vector3f.from(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public static Vector3f from(Vector4f v) {
        return Vector3f.from(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public static Vector3f from(VectorNf v) {
        return Vector3f.from(v.get(0), v.get(1), v.size() > 2 ? v.get(2) : 0.0f);
    }

    @Nonnull
    public static Vector3f from(double x, double y, double z) {
        return Vector3f.from((float)x, (float)y, (float)z);
    }

    @Nonnull
    public static Vector3f from(float x, float y, float z) {
        return Vectors.createVector3f(x, y, z);
    }

    @Nonnull
    public static Vector3f createRandomDirection(Random random) {
        return Vector3f.createDirectionRad(random.nextFloat() * ((float)Math.PI * 2), random.nextFloat() * ((float)Math.PI * 2));
    }

    @Nonnull
    public static Vector3f createDirectionDeg(double theta, double phi) {
        return Vector3f.createDirectionDeg((float)theta, (float)phi);
    }

    @Nonnull
    public static Vector3f createDirectionDeg(float theta, float phi) {
        return Vector3f.createDirectionRad((float)Math.toRadians(theta), (float)Math.toRadians(phi));
    }

    @Nonnull
    public static Vector3f createDirectionRad(double theta, double phi) {
        return Vector3f.createDirectionRad((float)theta, (float)phi);
    }

    @Nonnull
    public static Vector3f createDirectionRad(float theta, float phi) {
        float f = TrigMath.sin(phi);
        return Vector3f.from(f * TrigMath.cos(theta), f * TrigMath.sin(theta), TrigMath.cos(phi));
    }
}

