/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.network.compression;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.geysermc.mcprotocollib.network.compression.PacketCompression;

public class ZlibCompression
implements PacketCompression {
    private static final int ZLIB_BUFFER_SIZE = 8192;
    private final Deflater deflater;
    private final Inflater inflater;

    public ZlibCompression() {
        this(-1);
    }

    public ZlibCompression(int level) {
        this.deflater = new Deflater(level);
        this.inflater = new Inflater();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inflate(ByteBuf source, ByteBuf destination, int uncompressedSize) throws DataFormatException {
        int originalIndex = source.readerIndex();
        this.inflater.setInput(source.nioBuffer());
        try {
            while (!this.inflater.finished() && this.inflater.getBytesWritten() < (long)uncompressedSize) {
                if (!destination.isWritable()) {
                    destination.ensureWritable(8192);
                }
                ByteBuffer destNioBuf = destination.nioBuffer(destination.writerIndex(), destination.writableBytes());
                int produced = this.inflater.inflate(destNioBuf);
                destination.writerIndex(destination.writerIndex() + produced);
            }
            if (!this.inflater.finished()) {
                throw new DataFormatException("Received a deflate stream that was too large, wanted " + uncompressedSize);
            }
            source.readerIndex(originalIndex + this.inflater.getTotalIn());
        }
        finally {
            this.inflater.reset();
        }
    }

    @Override
    public void deflate(ByteBuf source, ByteBuf destination) {
        int originalIndex = source.readerIndex();
        this.deflater.setInput(source.nioBuffer());
        this.deflater.finish();
        while (!this.deflater.finished()) {
            if (!destination.isWritable()) {
                destination.ensureWritable(8192);
            }
            ByteBuffer destNioBuf = destination.nioBuffer(destination.writerIndex(), destination.writableBytes());
            int produced = this.deflater.deflate(destNioBuf);
            destination.writerIndex(destination.writerIndex() + produced);
        }
        source.readerIndex(originalIndex + this.deflater.getTotalIn());
        this.deflater.reset();
    }

    @Override
    public void close() {
        this.deflater.end();
        this.inflater.end();
    }
}

