/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.collision.fixes;

import lombok.Generated;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.CollisionRemapper;

@CollisionRemapper(regex="^lantern$|^soul_lantern$", usesParams=true, passDefaultBoxes=true)
public class LanternCollision
extends BlockCollision {
    private static final double MAX_PUSH_DISTANCE = 0.0625101;
    private final boolean hanging;

    public LanternCollision(BlockState state, BoundingBox[] boxes) {
        super(boxes);
        this.hanging = state.getValue(Properties.HANGING);
    }

    @Override
    protected void correctPosition(GeyserSession session, int x, int y, int z, BoundingBox blockCollision, BoundingBox playerCollision) {
        if (this.hanging) {
            blockCollision.pushOutOfBoundingBox(playerCollision, Direction.DOWN, 0.0625101);
        } else {
            blockCollision.pushOutOfBoundingBox(playerCollision, Direction.UP, 0.0625101);
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LanternCollision)) {
            return false;
        }
        LanternCollision other = (LanternCollision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.hanging == other.hanging;
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LanternCollision;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.hanging ? 79 : 97);
        return result;
    }
}

