/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.cloudburstmc.protocol.bedrock.data.AttributeData;
import org.cloudburstmc.protocol.bedrock.packet.ClientboundCloseFormPacket;
import org.cloudburstmc.protocol.bedrock.packet.ModalFormRequestPacket;
import org.cloudburstmc.protocol.bedrock.packet.ModalFormResponsePacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.form.impl.FormDefinition;
import org.geysermc.cumulus.form.impl.FormDefinitions;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntList;
import org.geysermc.geyser.session.GeyserSession;

public class FormCache {
    private static final long MAGIC_FORM_IMAGE_HACK_TIMESTAMP = -1234567890L;
    private final FormDefinitions formDefinitions = FormDefinitions.instance();
    private final AtomicInteger formIdCounter = new AtomicInteger(0);
    private final Int2ObjectMap<Form> forms = new Int2ObjectOpenHashMap<Form>();
    private final IntList sentFormIds = new IntArrayList();
    private final GeyserSession session;

    public boolean hasFormOpen() {
        return !this.forms.isEmpty() && !this.sentFormIds.isEmpty();
    }

    public int addForm(Form form) {
        int formId = this.formIdCounter.getAndIncrement();
        this.forms.put(formId, form);
        return formId;
    }

    public void showForm(Form form) {
        int formId = this.addForm(form);
        if (this.session.getUpstream().isInitialized()) {
            this.sendForm(formId, form);
        }
    }

    private void sendForm(int formId, Form form) {
        String jsonData = this.formDefinitions.codecFor(form).jsonData((Form)form);
        this.sentFormIds.add(formId);
        ModalFormRequestPacket formRequestPacket = new ModalFormRequestPacket();
        formRequestPacket.setFormId(formId);
        formRequestPacket.setFormData(jsonData);
        this.session.sendUpstreamPacket(formRequestPacket);
        if (form instanceof SimpleForm) {
            this.session.scheduleInEventLoop(() -> this.session.sendNetworkLatencyStackPacket(-1234567890L, false, () -> this.session.scheduleInEventLoop(() -> {
                UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
                attributesPacket.setRuntimeEntityId(this.session.getPlayerEntity().geyserId());
                AttributeData attribute = this.session.getPlayerEntity().getAttributes().get((Object)GeyserAttributeType.EXPERIENCE_LEVEL);
                if (attribute != null) {
                    attributesPacket.setAttributes(Collections.singletonList(attribute));
                } else {
                    attributesPacket.setAttributes(Collections.singletonList(GeyserAttributeType.EXPERIENCE_LEVEL.getAttribute(0.0f)));
                }
                this.session.sendUpstreamPacket(attributesPacket);
            }, 500L, TimeUnit.MILLISECONDS)), 500L, TimeUnit.MILLISECONDS);
        }
    }

    public void resendAllForms() {
        for (Int2ObjectMap.Entry entry : this.forms.int2ObjectEntrySet()) {
            this.sendForm(entry.getIntKey(), (Form)entry.getValue());
        }
    }

    public void handleResponse(ModalFormResponsePacket response) {
        Form form = (Form)this.forms.remove(response.getFormId());
        this.sentFormIds.rem(response.getFormId());
        if (form == null) {
            return;
        }
        try {
            ((FormDefinition)this.formDefinitions.definitionFor(form)).handleFormResponse((Form)form, response.getFormData());
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().error("Error while processing form response!", e);
        }
    }

    public void closeForms() {
        if (!this.forms.isEmpty()) {
            for (Int2ObjectMap.Entry entry : this.forms.int2ObjectEntrySet()) {
                if (this.sentFormIds.contains(entry.getIntKey())) continue;
                this.sendForm(entry.getIntKey(), (Form)entry.getValue());
            }
            this.session.sendUpstreamPacket(new ClientboundCloseFormPacket());
        }
    }

    @Generated
    public FormCache(GeyserSession session) {
        this.session = session;
    }
}

