/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.scoreboard;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.scoreboard.Scoreboard;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.ChatColor;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.NameTagVisibility;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.TeamColor;

public final class Team {
    public static final long LAST_UPDATE_DEFAULT = -1L;
    private static final long LAST_UPDATE_REMOVE = -2L;
    private final Scoreboard scoreboard;
    private final String id;
    private final Set<String> entities;
    private final Set<Entity> managedEntities;
    private @NonNull NameTagVisibility nameTagVisibility = NameTagVisibility.ALWAYS;
    private TeamColor color;
    private String name;
    private String prefix;
    private String suffix;
    private long lastUpdate;

    public Team(Scoreboard scoreboard, String id, String[] players, Component name, Component prefix, Component suffix, NameTagVisibility visibility, TeamColor color) {
        this.scoreboard = scoreboard;
        this.id = id;
        this.entities = new ObjectOpenHashSet<String>();
        this.managedEntities = new ObjectOpenHashSet<Entity>();
        this.lastUpdate = -1L;
        this.updateProperties(name, prefix, suffix, visibility, color);
        this.addEntities(players);
        this.lastUpdate = -1L;
    }

    public void addEntities(String ... names) {
        HashSet<String> added = new HashSet<String>();
        for (String name : names) {
            if (!this.entities.add(name)) continue;
            added.add(name);
            this.scoreboard.getPlayerToTeam().compute(name, (player, oldTeam) -> {
                if (oldTeam != null) {
                    oldTeam.entities.remove(player);
                    this.removeManagedEntity((String)player);
                }
                return this;
            });
        }
        if (added.isEmpty()) {
            return;
        }
        this.scoreboard.setTeamFor(this, added);
        this.addAddedEntities(added);
    }

    public void removeEntities(String ... names) {
        HashSet<String> removed = new HashSet<String>();
        for (String name : names) {
            if (this.entities.remove(name)) {
                removed.add(name);
            }
            this.scoreboard.getPlayerToTeam().remove(name, this);
        }
        this.removeRemovedEntities(removed);
    }

    public boolean hasEntity(String name) {
        return this.entities.contains(name);
    }

    public String displayName(String score) {
        String chatColor = ChatColor.chatColorFor(this.color);
        if ("\u00a7r".equals(chatColor)) {
            chatColor = "";
        }
        return chatColor + this.prefix + "\u00a7r" + chatColor + score + "\u00a7r" + chatColor + this.suffix;
    }

    public boolean isVisibleFor(String entity) {
        return switch (this.nameTagVisibility) {
            default -> throw new IncompatibleClassChangeError();
            case NameTagVisibility.HIDE_FOR_OTHER_TEAMS -> {
                Team team = this.scoreboard.getTeamFor(entity);
                if (team == null || team == this) {
                    yield true;
                }
                yield false;
            }
            case NameTagVisibility.HIDE_FOR_OWN_TEAM -> {
                if (!this.hasEntity(entity)) {
                    yield true;
                }
                yield false;
            }
            case NameTagVisibility.ALWAYS -> true;
            case NameTagVisibility.NEVER -> false;
        };
    }

    public void updateProperties(Component name, Component prefix, Component suffix, NameTagVisibility visibility, TeamColor color) {
        if (this.lastUpdate == -2L) {
            return;
        }
        String oldName = this.name;
        String oldPrefix = this.prefix;
        String oldSuffix = this.suffix;
        boolean oldVisible = this.isVisibleFor(this.playerName());
        TeamColor oldColor = this.color;
        this.name = MessageTranslator.convertMessageRaw(name, this.session().locale());
        this.prefix = MessageTranslator.convertMessageRaw(prefix, this.session().locale());
        this.suffix = MessageTranslator.convertMessageRaw(suffix, this.session().locale());
        if (visibility != null) {
            this.nameTagVisibility = visibility;
        }
        this.color = color;
        if (this.lastUpdate == -1L) {
            if (this.color != TeamColor.RESET || !this.prefix.isEmpty() || !this.suffix.isEmpty()) {
                this.markChanged();
            }
            return;
        }
        if (!(this.name.equals(oldName) && this.prefix.equals(oldPrefix) && this.suffix.equals(oldSuffix) && color == oldColor)) {
            this.markChanged();
            this.updateEntities();
            return;
        }
        if (this.isVisibleFor(this.playerName()) != oldVisible) {
            this.updateEntities();
        }
    }

    public boolean shouldRemove() {
        return this.lastUpdate == -2L;
    }

    public void markChanged() {
        if (this.lastUpdate == -2L) {
            return;
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    public void remove() {
        this.lastUpdate = -2L;
        for (String name : this.entities()) {
            this.scoreboard.getPlayerToTeam().remove(name);
        }
        if (this.entities().contains(this.playerName())) {
            this.refreshAllEntities();
            return;
        }
        for (Entity entity : this.managedEntities) {
            entity.updateNametag(null);
            entity.updateBedrockMetadata();
        }
    }

    private void updateEntities() {
        for (Entity entity : this.managedEntities) {
            entity.updateNametag(this);
            entity.updateBedrockMetadata();
        }
    }

    public void onEntitySpawn(Entity entity) {
        if (this.entities.contains(entity.teamIdentifier())) {
            this.managedEntities.add(entity);
            entity.updateNametag(this);
            entity.updateBedrockMetadata();
        }
    }

    public void onEntityRemove(Entity entity) {
        this.managedEntities.remove(entity);
    }

    private void addAddedEntities(Set<String> names) {
        if (names.isEmpty()) {
            return;
        }
        boolean containsSelf = names.contains(this.playerName());
        for (Entity entity : this.session().getEntityCache().getEntities().values()) {
            if (!names.contains(entity.teamIdentifier())) continue;
            this.managedEntities.add(entity);
            if (containsSelf) continue;
            entity.updateNametag(this);
            entity.updateBedrockMetadata();
        }
        if (containsSelf) {
            this.refreshAllEntities();
        }
    }

    private void removeRemovedEntities(Set<String> names) {
        boolean containsSelf = names.contains(this.playerName());
        Iterator<Entity> iterator = this.managedEntities.iterator();
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            if (!names.contains(entity.teamIdentifier())) continue;
            iterator.remove();
            if (containsSelf) continue;
            entity.updateNametag(null);
            entity.updateBedrockMetadata();
        }
        if (containsSelf) {
            this.refreshAllEntities();
        }
    }

    private void removeManagedEntity(String name) {
        this.managedEntities.removeIf(entity -> name.equals(entity.teamIdentifier()));
    }

    private void refreshAllEntities() {
        for (Entity entity : this.session().getEntityCache().getEntities().values()) {
            entity.updateNametag(this.scoreboard.getTeamFor(entity.teamIdentifier()));
            entity.updateBedrockMetadata();
        }
    }

    private GeyserSession session() {
        return this.scoreboard.session();
    }

    private String playerName() {
        return this.session().getPlayerEntity().getUsername();
    }

    public String id() {
        return this.id;
    }

    public TeamColor color() {
        return this.color;
    }

    public long lastUpdate() {
        return this.lastUpdate;
    }

    public Set<String> entities() {
        return this.entities;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

