/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.registry.Registry;
import org.geysermc.geyser.registry.loader.RegistryLoader;
import org.jetbrains.annotations.NotNull;

public class ListRegistry<M>
extends Registry<List<M>>
implements Iterable<M> {
    private boolean frozen = false;

    protected <I> ListRegistry(I input, RegistryLoader<I, List<M>> registryLoader) {
        super(input, registryLoader);
    }

    public @Nullable M get(int index) {
        if (index < 0 || index >= ((List)this.mappings).size()) {
            return null;
        }
        return (M)((List)this.mappings).get(index);
    }

    public M getOrDefault(int index, M defaultValue) {
        M value = this.get(index);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public M register(int index, M value) {
        if (this.frozen) {
            throw new IllegalStateException("Registry should not be modified after frozen!");
        }
        return ((List)this.mappings).set(index, value);
    }

    public M registerWithAnyIndex(int index, M value, M defaultValue) {
        if (this.frozen) {
            throw new IllegalStateException("Registry should not be modified after frozen!");
        }
        if (((List)this.mappings).size() <= index) {
            ((List)this.mappings).addAll(Collections.nCopies(index - ((List)this.mappings).size() + 1, defaultValue));
        }
        return ((List)this.mappings).set(index, value);
    }

    @Override
    @NotNull
    public Iterator<M> iterator() {
        return ((List)this.get()).iterator();
    }

    public void freeze() {
        if (!this.frozen) {
            this.frozen = true;
            Object object = this.mappings;
            if (object instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)object;
                arrayList.trimToSize();
            }
        }
    }

    public static <I, M> ListRegistry<M> create(RegistryLoader<I, List<M>> registryLoader) {
        return new ListRegistry<M>(null, registryLoader);
    }

    public static <I, M> ListRegistry<M> create(I input, RegistryLoader<I, List<M>> registryLoader) {
        return new ListRegistry<M>(input, registryLoader);
    }

    public static <I, M> ListRegistry<M> create(I input, Supplier<RegistryLoader<I, List<M>>> registryLoader) {
        return new ListRegistry<M>(input, registryLoader.get());
    }
}

