/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot.shaded.marcono1234.gson.recordadapter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Optional;

public interface JsonAdapterCreator {
    public static final JsonAdapterCreator DEFAULT_CONSTRUCTOR_INVOKER = new JsonAdapterCreator(){

        @Override
        public Optional<Object> create(Class<?> c) throws AdapterCreationException {
            Constructor<?> constructor;
            int modifiers = c.getModifiers();
            if (Modifier.isAbstract(modifiers) || !Modifier.isStatic(modifiers)) {
                return Optional.empty();
            }
            try {
                constructor = c.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return Optional.empty();
            }
            try {
                constructor.setAccessible(true);
                return Optional.of(constructor.newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InaccessibleObjectException e) {
                throw new AdapterCreationException("Default constructor of " + c + " is not accessible; open it to this library or register a custom JsonAdapterCreator", e);
            }
            catch (InstantiationException e) {
                throw new AdapterCreationException("Failed invoking default constructor for " + c, e);
            }
            catch (InvocationTargetException e) {
                throw new AdapterCreationException("Failed invoking default constructor for " + c, e.getCause());
            }
        }

        public String toString() {
            return "DEFAULT_CONSTRUCTOR_INVOKER";
        }
    };

    public Optional<Object> create(Class<?> var1) throws AdapterCreationException;

    public static class AdapterCreationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public AdapterCreationException(String message) {
            super(message);
        }

        public AdapterCreationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

