/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.geysermc.geyser.util.metrics.MetricsPlatform;

public final class SpigotMetrics
implements MetricsPlatform {
    private final YamlConfiguration config;

    public SpigotMetrics(Plugin plugin) {
        File bStatsFolder = new File(plugin.getDataFolder().getParentFile(), "bStats");
        File configFile = new File(bStatsFolder, "config.yml");
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
        if (!this.config.isSet("serverUuid")) {
            this.config.addDefault("enabled", (Object)true);
            this.config.addDefault("serverUuid", (Object)UUID.randomUUID().toString());
            this.config.addDefault("logFailedRequests", (Object)false);
            this.config.addDefault("logSentData", (Object)false);
            this.config.addDefault("logResponseStatusText", (Object)false);
            this.config.options().header("bStats (https://bStats.org) collects some basic information for plugin authors, like how\nmany people use their plugin and their total player count. It's recommended to keep bStats\nenabled, but if you're not comfortable with this, you can turn this setting off. There is no\nperformance penalty associated with having metrics enabled, and data sent to bStats is fully\nanonymous.").copyDefaults(true);
            try {
                this.config.save(configFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean enabled() {
        return this.config.getBoolean("enabled", true);
    }

    @Override
    public String serverUuid() {
        return this.config.getString("serverUuid");
    }

    @Override
    public boolean logFailedRequests() {
        return this.config.getBoolean("logFailedRequests", false);
    }

    @Override
    public boolean logSentData() {
        return this.config.getBoolean("logSentData", false);
    }

    @Override
    public boolean logResponseStatusText() {
        return this.config.getBoolean("logResponseStatusText", false);
    }
}

