/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.item;

import java.util.Collections;
import java.util.Locale;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.PotionContents;

public enum Potion {
    WATER(0, 3694022),
    MUNDANE(1, 3694022),
    THICK(3, 3694022),
    AWKWARD(4, 3694022),
    NIGHT_VISION(5, 12779366),
    LONG_NIGHT_VISION(6, 12779366),
    INVISIBILITY(7, 0xF6F6F6),
    LONG_INVISIBILITY(8, 0xF6F6F6),
    LEAPING(9, 16646020),
    LONG_LEAPING(10, 16646020),
    STRONG_LEAPING(11, 16646020),
    FIRE_RESISTANCE(12, 0xFF9900),
    LONG_FIRE_RESISTANCE(13, 0xFF9900),
    SWIFTNESS(14, 3402751),
    LONG_SWIFTNESS(15, 3402751),
    STRONG_SWIFTNESS(16, 3402751),
    SLOWNESS(17, 9154528),
    LONG_SLOWNESS(18, 9154528),
    STRONG_SLOWNESS(42, 9154528),
    TURTLE_MASTER(37, 9274086),
    LONG_TURTLE_MASTER(38, 9274086),
    STRONG_TURTLE_MASTER(39, 9274854),
    WATER_BREATHING(19, 10017472),
    LONG_WATER_BREATHING(20, 10017472),
    HEALING(21, 16262179),
    STRONG_HEALING(22, 16262179),
    HARMING(23, 11101546),
    STRONG_HARMING(24, 11101546),
    POISON(25, 8889187),
    LONG_POISON(26, 8889187),
    STRONG_POISON(27, 8889187),
    REGENERATION(28, 13458603),
    LONG_REGENERATION(29, 13458603),
    STRONG_REGENERATION(30, 13458603),
    STRENGTH(31, 16762624),
    LONG_STRENGTH(32, 16762624),
    STRONG_STRENGTH(33, 16762624),
    WEAKNESS(34, 0x484D48),
    LONG_WEAKNESS(35, 0x484D48),
    LUCK(2, 5882118),
    SLOW_FALLING(40, 15978425),
    LONG_SLOW_FALLING(41, 15978425),
    WIND_CHARGING(43, 12438015),
    WEAVING(44, 7891290),
    OOZING(45, 10092451),
    INFESTATION(46, 9214860);

    public static final Potion[] VALUES;
    private final String javaIdentifier = "minecraft:" + this.name().toLowerCase(Locale.ENGLISH);
    private final short bedrockId;
    private final int javaColor;

    private Potion(int bedrockId, int javaColor) {
        this.bedrockId = (short)bedrockId;
        this.javaColor = javaColor;
    }

    public int tippedArrowId() {
        return this.bedrockId + 1;
    }

    public PotionContents toComponent() {
        return new PotionContents(this.ordinal(), -1, Collections.emptyList(), null);
    }

    public static Potion getByJavaIdentifier(String javaIdentifier) {
        for (Potion potion : VALUES) {
            if (!potion.javaIdentifier.equals(javaIdentifier)) continue;
            return potion;
        }
        return null;
    }

    public static @Nullable Potion getByJavaId(int javaId) {
        if (javaId >= 0 && javaId < VALUES.length) {
            return VALUES[javaId];
        }
        return null;
    }

    public static @Nullable Potion getByBedrockId(int bedrockId) {
        for (Potion potion : VALUES) {
            if (potion.bedrockId != bedrockId) continue;
            return potion;
        }
        return null;
    }

    public static @Nullable Potion getByTippedArrowDamage(int bedrockId) {
        return Potion.getByBedrockId(bedrockId - 1);
    }

    public static byte toTippedArrowId(int javaParticleColor) {
        for (Potion potion : VALUES) {
            if (potion.javaColor != javaParticleColor) continue;
            return (byte)(potion.bedrockId + 1);
        }
        return 0;
    }

    @Generated
    public String getJavaIdentifier() {
        return this.javaIdentifier;
    }

    @Generated
    public short getBedrockId() {
        return this.bedrockId;
    }

    @Generated
    public int getJavaColor() {
        return this.javaColor;
    }

    static {
        VALUES = Potion.values();
    }

    private static final class ArrowParticleColors {
        static final int NONE = 3694022;
        static final int NIGHT_VISION = 12779366;
        static final int INVISIBILITY = 0xF6F6F6;
        static final int LEAPING = 16646020;
        static final int FIRE_RESISTANCE = 0xFF9900;
        static final int SWIFTNESS = 3402751;
        static final int SLOWNESS = 9154528;
        static final int TURTLE_MASTER = 9274086;
        static final int TURTLE_MASTER_ENHANCED = 9274854;
        static final int WATER_BREATHING = 10017472;
        static final int HEALING = 16262179;
        static final int HARMING = 11101546;
        static final int POISON = 8889187;
        static final int REGENERATION = 13458603;
        static final int STRENGTH = 16762624;
        static final int WEAKNESS = 0x484D48;
        static final int LUCK = 5882118;
        static final int SLOW_FALLING = 15978425;
        static final int WIND_CHARGING = 12438015;
        static final int WEAVING = 7891290;
        static final int OOZING = 10092451;
        static final int INFESTATION = 9214860;

        private ArrowParticleColors() {
        }
    }
}

