/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import java.util.List;
import lombok.Generated;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;

public final class InventoryHolder<T extends Inventory> {
    private final GeyserSession session;
    private final T inventory;
    private final InventoryTranslator<T> translator;
    private boolean pending;
    private int containerOpenAttempts;

    public InventoryHolder(GeyserSession session, Inventory newInventory, InventoryTranslator<? extends Inventory> newTranslator) {
        this.session = session;
        this.inventory = newInventory;
        this.translator = newTranslator;
    }

    public void markCurrent() {
        this.session.setInventoryHolder(this);
    }

    public boolean shouldSetPending() {
        return this.session.isClosingInventory() || !this.session.getUpstream().isInitialized() || this.session.getPendingOrCurrentBedrockInventoryId() != -1;
    }

    public boolean shouldConfirmClose(boolean confirm) {
        return confirm && ((Inventory)this.inventory).isDisplayed() && !this.pending;
    }

    public void inheritFromExisting(InventoryHolder<? extends Inventory> existing) {
        ((Inventory)this.inventory).setBedrockId(existing.bedrockId());
        T existingInventory = existing.inventory;
        this.pending = existing.pending();
        ((Inventory)this.inventory).setDisplayed(((Inventory)existingInventory).isDisplayed());
        ((Inventory)this.inventory).setHolderPosition(((Inventory)existingInventory).getHolderPosition());
        ((Inventory)this.inventory).setHolderId(((Inventory)existingInventory).getHolderId());
        this.markCurrent();
    }

    public void updateInventory() {
        this.translator.updateInventory(this.session, this.inventory);
    }

    public void updateProperty(int rawProperty, int value) {
        this.translator.updateProperty(this.session, this.inventory, rawProperty, value);
    }

    public void updateSlot(int slot) {
        this.translator.updateSlot(this.session, this.inventory, slot);
    }

    public void openInventory() {
        this.translator.openInventory(this.session, this.inventory);
        this.pending = false;
        ((Inventory)this.inventory).setDisplayed(true);
    }

    public void closeInventory(boolean force) {
        this.translator.closeInventory(this.session, this.inventory, force);
        if (this.session.getContainerOutputFuture() != null) {
            this.session.getContainerOutputFuture().cancel(true);
        }
    }

    public boolean requiresOpeningDelay() {
        return this.translator.requiresOpeningDelay(this.session, this.inventory);
    }

    public boolean prepareInventory() {
        return this.translator.prepareInventory(this.session, this.inventory);
    }

    public void translateRequests(List<ItemStackRequest> requests) {
        this.translator.translateRequests(this.session, this.inventory, requests);
    }

    public GeyserSession session() {
        return this.session;
    }

    public T inventory() {
        return this.inventory;
    }

    public InventoryTranslator<T> translator() {
        return this.translator;
    }

    public void incrementContainerOpenAttempts() {
        ++this.containerOpenAttempts;
    }

    public int javaId() {
        return ((Inventory)this.inventory).getJavaId();
    }

    public int bedrockId() {
        return ((Inventory)this.inventory).getBedrockId();
    }

    public String toString() {
        return "InventoryHolder[session=" + this.session.bedrockUsername() + ", inventory=" + String.valueOf(this.inventory) + ", pending= " + this.pending + ", containerOpenAttempts=" + this.containerOpenAttempts + ", translator=" + this.translator.getClass().getSimpleName() + "]";
    }

    @Generated
    public boolean pending() {
        return this.pending;
    }

    @Generated
    public int containerOpenAttempts() {
        return this.containerOpenAttempts;
    }

    @Generated
    public InventoryHolder<T> pending(boolean pending) {
        this.pending = pending;
        return this;
    }

    @Generated
    public InventoryHolder<T> containerOpenAttempts(int containerOpenAttempts) {
        this.containerOpenAttempts = containerOpenAttempts;
        return this;
    }
}

