/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.player;

import java.util.Collections;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityLinkData;
import org.cloudburstmc.protocol.bedrock.packet.PlayerListPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityLinkPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.entity.type.player.GeyserPlayerEntity;
import org.geysermc.geyser.entity.VanillaEntities;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.animal.tameable.ParrotEntity;
import org.geysermc.geyser.entity.type.player.AvatarEntity;
import org.geysermc.geyser.util.PlayerListUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.FloatEntityMetadata;

public class PlayerEntity
extends AvatarEntity
implements GeyserPlayerEntity {
    private @Nullable ParrotEntity leftParrot;
    private @Nullable ParrotEntity rightParrot;
    private boolean listed = false;

    public PlayerEntity(EntitySpawnContext context, String username, @Nullable String texturesProperty) {
        super(context, username);
        this.texturesProperty = texturesProperty;
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityDataTypes.NAMETAG_ALWAYS_SHOW, (byte)1);
    }

    @Override
    public void despawnEntity() {
        super.despawnEntity();
        if (PlayerListUtils.shouldLimitPlayerListEntries(this.session)) {
            PlayerListPacket packet = new PlayerListPacket();
            packet.getEntries().add(new PlayerListPacket.Entry(this.getTabListUuid()));
            packet.setAction(PlayerListPacket.Action.REMOVE);
            this.session.sendUpstreamPacket(packet);
            this.session.getWaypointCache().unlistPlayer(this);
        }
        this.resetMetadata();
        this.nametag = this.username;
        this.equipment.clear();
    }

    public void resetMetadata() {
        this.flags.clear();
        this.initializeMetadata();
        this.setParrot(OptionalInt.empty(), true);
        this.setParrot(OptionalInt.empty(), false);
    }

    public void sendPlayer() {
        if (this.session.getEntityCache().getPlayerEntity(this.uuid) == null) {
            return;
        }
        this.session.getEntityCache().spawnEntity(this);
    }

    @Override
    public void moveAbsoluteRaw(Vector3f javaPosition, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        super.moveAbsoluteRaw(javaPosition, yaw, pitch, headYaw, isOnGround, teleported);
        if (this.leftParrot != null) {
            this.leftParrot.moveAbsoluteRaw(javaPosition, yaw, pitch, headYaw, true, teleported);
        }
        if (this.rightParrot != null) {
            this.rightParrot.moveAbsoluteRaw(javaPosition, yaw, pitch, headYaw, true, teleported);
        }
    }

    @Override
    public void moveRelativeRaw(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        super.moveRelativeRaw(relX, relY, relZ, yaw, pitch, headYaw, isOnGround);
        if (this.leftParrot != null) {
            this.leftParrot.moveRelativeRaw(relX, relY, relZ, yaw, pitch, headYaw, true);
        }
        if (this.rightParrot != null) {
            this.rightParrot.moveRelativeRaw(relX, relY, relZ, yaw, pitch, headYaw, true);
        }
    }

    public void setAbsorptionHearts(FloatEntityMetadata entityMetadata) {
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(this.geyserId);
        attributesPacket.setAttributes(Collections.singletonList(GeyserAttributeType.ABSORPTION.getAttribute(entityMetadata.getPrimitiveValue())));
        this.session.sendUpstreamPacket(attributesPacket);
    }

    public void setLeftParrot(EntityMetadata<OptionalInt, ?> entityMetadata) {
        this.setParrot(entityMetadata.getValue(), true);
    }

    public void setRightParrot(EntityMetadata<OptionalInt, ?> entityMetadata) {
        this.setParrot(entityMetadata.getValue(), false);
    }

    protected void setParrot(OptionalInt variant, boolean isLeft) {
        if (variant.isPresent()) {
            if (isLeft && this.leftParrot != null || !isLeft && this.rightParrot != null) {
                return;
            }
            EntitySpawnContext context = EntitySpawnContext.inherited(this.session, VanillaEntities.PARROT, this, this.position());
            if (context.callParrotEvent(this, variant.getAsInt(), !isLeft)) {
                GeyserImpl.getInstance().getLogger().debug(this.session, "Cancelled parrot spawn as definition is null!", new Object[0]);
                return;
            }
            ParrotEntity parrot = new ParrotEntity(context);
            parrot.getDirtyMetadata().put(EntityDataTypes.VARIANT, variant.getAsInt());
            if (context.consumers() != null) {
                context.consumers().forEach(consumer -> consumer.accept(parrot));
            }
            parrot.spawnEntity();
            float offset = isLeft ? 0.4f : -0.4f;
            parrot.getDirtyMetadata().put(EntityDataTypes.SEAT_OFFSET, Vector3f.from((double)offset, -0.22, -0.1));
            parrot.getDirtyMetadata().put(EntityDataTypes.SEAT_LOCK_RIDER_ROTATION, true);
            parrot.updateBedrockMetadata();
            SetEntityLinkPacket linkPacket = new SetEntityLinkPacket();
            EntityLinkData.Type type = isLeft ? EntityLinkData.Type.RIDER : EntityLinkData.Type.PASSENGER;
            linkPacket.setEntityLink(new EntityLinkData(this.geyserId, parrot.geyserId(), type, false, false, 0.0f));
            this.session.scheduleInEventLoop(() -> this.session.sendUpstreamPacket(linkPacket), 500L, TimeUnit.MILLISECONDS);
            if (isLeft) {
                this.leftParrot = parrot;
            } else {
                this.rightParrot = parrot;
            }
        } else {
            ParrotEntity parrot;
            ParrotEntity parrotEntity = parrot = isLeft ? this.leftParrot : this.rightParrot;
            if (parrot != null) {
                parrot.despawnEntity();
                if (isLeft) {
                    this.leftParrot = null;
                } else {
                    this.rightParrot = null;
                }
            }
        }
    }

    @Override
    public String teamIdentifier() {
        return this.username;
    }

    @Override
    protected void setNametag(@Nullable String nametag, boolean fromDisplayName) {
        if (nametag == null && !fromDisplayName) {
            nametag = this.username;
        }
        super.setNametag(nametag, fromDisplayName);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public UUID getTabListUuid() {
        return this.uuid();
    }

    public Pose getDesiredPose() {
        if (this.getBedPosition() != null) {
            return Pose.SLEEPING;
        }
        if (this.getFlag(EntityFlag.SWIMMING) || this.getFlag(EntityFlag.CRAWLING)) {
            return Pose.SWIMMING;
        }
        if (this.getFlag(EntityFlag.GLIDING)) {
            return Pose.FALL_FLYING;
        }
        if (this.getFlag(EntityFlag.DAMAGE_NEARBY_MOBS)) {
            return Pose.SPIN_ATTACK;
        }
        return this.getFlag(EntityFlag.SNEAKING) && !this.session.isFlying() ? Pose.SNEAKING : Pose.STANDING;
    }

    @Generated
    public @Nullable ParrotEntity getLeftParrot() {
        return this.leftParrot;
    }

    @Generated
    public @Nullable ParrotEntity getRightParrot() {
        return this.rightParrot;
    }

    @Override
    @Generated
    public boolean isListed() {
        return this.listed;
    }

    @Generated
    public void setListed(boolean listed) {
        this.listed = listed;
    }
}

