/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living;

import java.util.Optional;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.VanillaEntities;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.LivingEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.scoreboard.Team;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.EquipmentSlot;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class ArmorStandEntity
extends LivingEntity {
    private boolean isMarker = false;
    private boolean isInvisible = false;
    private boolean isSmall = false;
    private boolean isNameTagVisible = false;
    private ArmorStandEntity secondEntity = null;
    private boolean primaryEntity = true;
    private boolean positionRequiresOffset = false;
    private boolean positionUpdateRequired = false;

    public ArmorStandEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    public void spawnEntity() {
        this.offset(this.getYOffset(), false);
        super.spawnEntity();
    }

    @Override
    public void despawnEntity() {
        if (this.secondEntity != null) {
            this.secondEntity.despawnEntity();
        }
        super.despawnEntity();
    }

    @Override
    public void moveRelativeRaw(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        this.moveAbsoluteRaw(this.position().add(relX, relY, relZ), yaw, pitch, headYaw, this.onGround, false);
    }

    @Override
    public void moveAbsoluteRaw(Vector3f javaPosition, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        if (this.secondEntity != null) {
            this.secondEntity.moveAbsoluteRaw(javaPosition, yaw, pitch, headYaw, isOnGround, teleported);
        }
        this.offset(this.getYOffset(), false);
        super.moveAbsoluteRaw(javaPosition, yaw, yaw, yaw, isOnGround, teleported);
    }

    @Override
    public void updateNametag(@Nullable Team team) {
        super.updateNametag(team, true);
    }

    @Override
    public void setDisplayName(EntityMetadata<Optional<Component>, ?> entityMetadata) {
        super.setDisplayName(entityMetadata);
        this.updateSecondEntityStatus(false);
    }

    public void setArmorStandFlags(ByteEntityMetadata entityMetadata) {
        boolean newIsSmall;
        byte xd = entityMetadata.getPrimitiveValue();
        boolean offsetChanged = false;
        boolean bl = newIsSmall = (xd & 1) == 1;
        if (newIsSmall != this.isSmall) {
            this.isSmall = newIsSmall;
            offsetChanged = true;
            this.updatePassengerOffsets();
        }
        boolean oldIsMarker = this.isMarker;
        boolean bl2 = this.isMarker = (xd & 0x10) == 16;
        if (oldIsMarker != this.isMarker) {
            if (this.isMarker) {
                this.setBoundingBoxWidth(0.0f);
                this.setBoundingBoxHeight(0.0f);
            } else {
                this.setBoundingBoxWidth(this.width);
                this.setBoundingBoxHeight(this.height);
            }
            this.updateMountOffset();
            offsetChanged = true;
        }
        if (offsetChanged) {
            if (this.positionRequiresOffset) {
                this.positionUpdateRequired = true;
            } else if (this.secondEntity != null) {
                this.secondEntity.positionUpdateRequired = true;
            }
            this.updateSecondEntityStatus(false);
        }
        this.setFlag(EntityFlag.ANGRY, (xd & 4) != 4);
        this.setFlag(EntityFlag.ADMIRING, (xd & 8) == 8);
        this.setFlag(EntityFlag.BABY, this.isSmall);
    }

    public void setHeadRotation(EntityMetadata<Vector3f, ?> entityMetadata) {
        this.onRotationUpdate(EntityDataTypes.MARK_VARIANT, EntityFlag.INTERESTED, EntityFlag.CHARGED, EntityFlag.POWERED, entityMetadata.getValue());
    }

    public void setBodyRotation(EntityMetadata<Vector3f, ?> entityMetadata) {
        this.onRotationUpdate(EntityDataTypes.VARIANT, EntityFlag.IN_LOVE, EntityFlag.CELEBRATING, EntityFlag.CELEBRATING_SPECIAL, entityMetadata.getValue());
    }

    public void setLeftArmRotation(EntityMetadata<Vector3f, ?> entityMetadata) {
        this.onRotationUpdate(EntityDataTypes.TRADE_TIER, EntityFlag.CHARGING, EntityFlag.CRITICAL, EntityFlag.DANCING, entityMetadata.getValue());
    }

    public void setRightArmRotation(EntityMetadata<Vector3f, ?> entityMetadata) {
        this.onRotationUpdate(EntityDataTypes.MAX_TRADE_TIER, EntityFlag.ELDER, EntityFlag.EMOTING, EntityFlag.IDLING, entityMetadata.getValue());
    }

    public void setLeftLegRotation(EntityMetadata<Vector3f, ?> entityMetadata) {
        this.onRotationUpdate(EntityDataTypes.SKIN_ID, EntityFlag.IS_ILLAGER_CAPTAIN, EntityFlag.IS_IN_UI, EntityFlag.LINGERING, entityMetadata.getValue());
    }

    public void setRightLegRotation(EntityMetadata<Vector3f, ?> entityMetadata) {
        this.onRotationUpdate(EntityDataTypes.HURT_DIRECTION, EntityFlag.IS_PREGNANT, EntityFlag.SHEARED, EntityFlag.STALKING, entityMetadata.getValue());
    }

    private void onRotationUpdate(EntityDataType<Integer> dataLeech, EntityFlag negativeXToggle, EntityFlag negativeYToggle, EntityFlag negativeZToggle, Vector3f rotation) {
        this.setFlag(EntityFlag.BRIBED, true);
        int rotationX = MathUtils.wrapDegreesToInt(rotation.getX());
        int rotationY = MathUtils.wrapDegreesToInt(rotation.getY());
        int rotationZ = MathUtils.wrapDegreesToInt(rotation.getZ());
        int topBit = (Math.abs(rotationX) >= 100 ? 4 : 0) + (Math.abs(rotationY) >= 100 ? 2 : 0) + (Math.abs(rotationZ) >= 100 ? 1 : 0);
        int value = topBit * 1000000 + Math.abs(rotationX) % 100 * 10000 + Math.abs(rotationY) % 100 * 100 + Math.abs(rotationZ) % 100;
        this.dirtyMetadata.put(dataLeech, value);
        this.setFlag(negativeXToggle, rotationX < 0);
        this.setFlag(negativeYToggle, rotationY < 0);
        this.setFlag(negativeZToggle, rotationZ < 0);
    }

    @Override
    public void updateBedrockMetadata() {
        if (this.secondEntity != null) {
            this.secondEntity.updateBedrockMetadata();
        }
        super.updateBedrockMetadata();
        if (this.positionUpdateRequired) {
            this.positionUpdateRequired = false;
            this.moveAbsoluteRaw(this.position(), this.yaw, this.pitch, this.headYaw, this.onGround, true);
        }
    }

    @Override
    protected void setInvisible(boolean value) {
        if (this.primaryEntity) {
            this.isInvisible = value;
            this.updateSecondEntityStatus(false);
        }
    }

    @Override
    public InteractionResult interactAt(Hand hand) {
        if (!this.isMarker && !this.session.getPlayerInventory().getItemInHand(hand).is(Items.NAME_TAG)) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void setHelmet(GeyserItemStack helmet) {
        super.setHelmet(helmet);
        this.updateSecondEntityStatus(true);
    }

    @Override
    public void setChestplate(GeyserItemStack chestplate) {
        super.setChestplate(chestplate);
        this.updateSecondEntityStatus(true);
    }

    @Override
    public void setLeggings(GeyserItemStack leggings) {
        super.setLeggings(leggings);
        this.updateSecondEntityStatus(true);
    }

    @Override
    public void setBoots(GeyserItemStack boots) {
        super.setBoots(boots);
        this.updateSecondEntityStatus(true);
    }

    @Override
    public void setHand(GeyserItemStack hand) {
        super.setHand(hand);
        this.updateSecondEntityStatus(true);
    }

    @Override
    public void setOffhand(GeyserItemStack offHand) {
        super.setOffhand(offHand);
        this.updateSecondEntityStatus(true);
    }

    @Override
    public void setDisplayNameVisible(BooleanEntityMetadata entityMetadata) {
        super.setDisplayNameVisible(entityMetadata);
        this.isNameTagVisible = entityMetadata.getPrimitiveValue();
        this.updateSecondEntityStatus(false);
    }

    private void updateSecondEntityStatus(boolean sendMetadata) {
        if (!this.primaryEntity) {
            return;
        }
        if (!this.isInvisible) {
            this.setFlag(EntityFlag.INVISIBLE, false);
            this.setScale(this.getScale());
            this.updateOffsetRequirement(false);
            if (this.secondEntity != null) {
                this.secondEntity.despawnEntity();
                this.secondEntity = null;
            }
            if (sendMetadata) {
                this.updateBedrockMetadata();
            }
            return;
        }
        boolean isNametagEmpty = this.nametag.isEmpty();
        if (!isNametagEmpty && this.hasAnyEquipment()) {
            this.setScale(this.getScale());
            this.setFlag(EntityFlag.INVISIBLE, true);
            this.updateOffsetRequirement(false);
            if (this.secondEntity == null) {
                this.secondEntity = new ArmorStandEntity(EntitySpawnContext.inherited(this.session, VanillaEntities.ARMOR_STAND, this, this.position()));
                this.secondEntity.primaryEntity = false;
            }
            this.secondEntity.isSmall = this.isSmall;
            this.secondEntity.isMarker = this.isMarker;
            this.secondEntity.positionRequiresOffset = true;
            this.secondEntity.getDirtyMetadata().put(EntityDataTypes.NAME, this.nametag);
            this.secondEntity.getDirtyMetadata().put(EntityDataTypes.NAMETAG_ALWAYS_SHOW, this.isNameTagVisible ? (byte)1 : 0);
            this.secondEntity.flags.putAll(this.flags);
            this.secondEntity.setFlag(EntityFlag.INVISIBLE, false);
            this.secondEntity.setScale(0.0f);
            this.secondEntity.getDirtyMetadata().put(EntityDataTypes.WIDTH, Float.valueOf(0.0f));
            this.secondEntity.getDirtyMetadata().put(EntityDataTypes.HEIGHT, Float.valueOf(0.0f));
            if (!this.secondEntity.valid) {
                this.secondEntity.spawnEntity();
            }
        } else if (isNametagEmpty) {
            this.setScale(this.getScale());
            this.setFlag(EntityFlag.INVISIBLE, true);
            this.updateOffsetRequirement(false);
            if (this.secondEntity != null) {
                this.secondEntity.despawnEntity();
                this.secondEntity = null;
            }
        } else {
            this.setFlag(EntityFlag.INVISIBLE, false);
            this.setScale(0.0f);
            this.updateOffsetRequirement(!this.isMarker);
            if (this.secondEntity != null) {
                this.secondEntity.despawnEntity();
                this.secondEntity = null;
            }
        }
        if (sendMetadata) {
            this.updateBedrockMetadata();
        }
    }

    private boolean hasAnyEquipment() {
        return !this.getItemInSlot(EquipmentSlot.HELMET).isEmpty() || !this.getItemInSlot(EquipmentSlot.CHESTPLATE).isEmpty() || !this.getItemInSlot(EquipmentSlot.LEGGINGS).isEmpty() || !this.getItemInSlot(EquipmentSlot.BOOTS).isEmpty() || !this.getMainHandItem().isEmpty() || !this.getOffHandItem().isEmpty();
    }

    @Override
    public float getBoundingBoxWidth() {
        return super.getBoundingBoxWidth() * this.getScale();
    }

    @Override
    public float getBoundingBoxHeight() {
        return super.getBoundingBoxHeight() * this.getScale();
    }

    public float getYOffset() {
        if (!this.positionRequiresOffset || this.isMarker || this.secondEntity != null) {
            return 0.0f;
        }
        return this.height * this.getScale();
    }

    private float getScale() {
        return this.isSmall ? 0.5f : 1.0f;
    }

    private void updateOffsetRequirement(boolean newValue) {
        if (newValue != this.positionRequiresOffset) {
            this.positionRequiresOffset = newValue;
            this.positionUpdateRequired = true;
            this.updatePassengerOffsets();
        }
    }

    @Override
    public Vector3f getBedrockRotation() {
        return Vector3f.from(this.getYaw(), this.getYaw(), this.getYaw());
    }

    @Generated
    public boolean isMarker() {
        return this.isMarker;
    }

    @Generated
    public boolean isSmall() {
        return this.isSmall;
    }
}

