/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.ThrowableEntity;

public class FireballEntity
extends ThrowableEntity {
    private final Vector3f acceleration;
    protected int futureTicks = 3;

    public FireballEntity(EntitySpawnContext context) {
        super(context.motion(Vector3f.ZERO));
        float magnitude = this.motion.length();
        this.acceleration = magnitude != 0.0f ? this.motion.div(magnitude).mul(0.1f) : Vector3f.ZERO;
    }

    private Vector3f tickMovement(Vector3f position) {
        position = position.add(this.motion);
        float drag = this.getDrag();
        this.motion = this.motion.add(this.acceleration).mul(drag);
        return position;
    }

    @Override
    protected void moveAbsoluteImmediate(Vector3f javaPosition, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        Vector3f lastMotion = this.motion;
        Vector3f newPosition = javaPosition;
        for (int i = 0; i < this.futureTicks; ++i) {
            newPosition = this.tickMovement(newPosition);
        }
        super.moveAbsoluteImmediate(newPosition, yaw, pitch, headYaw, isOnGround, teleported);
        this.setPosition(javaPosition);
        this.motion = lastMotion;
    }

    @Override
    public void tick() {
        if (this.removedInVoid()) {
            return;
        }
        this.moveAbsoluteImmediate(this.tickMovement(this.position()), this.getYaw(), this.getPitch(), this.getHeadYaw(), false, false);
    }
}

