/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import org.cloudburstmc.protocol.bedrock.data.LevelEventType;
import org.cloudburstmc.protocol.bedrock.data.ParticleType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.FloatEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.ColorParticleData;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.Particle;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.ParticleData;

public class AreaEffectCloudEntity
extends Entity {
    public AreaEffectCloudEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityDataTypes.AREA_EFFECT_CLOUD_DURATION, Integer.MAX_VALUE);
        this.dirtyMetadata.put(EntityDataTypes.AREA_EFFECT_CLOUD_RADIUS, Float.valueOf(3.0f));
        this.dirtyMetadata.put(EntityDataTypes.AREA_EFFECT_CLOUD_CHANGE_ON_PICKUP, Float.valueOf(Float.MIN_VALUE));
        this.dirtyMetadata.put(EntityDataTypes.AREA_EFFECT_CLOUD_CHANGE_RATE, Float.valueOf(Float.MIN_VALUE));
        this.setFlag(EntityFlag.FIRE_IMMUNE, true);
    }

    public void setRadius(FloatEntityMetadata entityMetadata) {
        float value = MathUtils.clamp(entityMetadata.getPrimitiveValue(), 0.5f, 32.0f);
        this.dirtyMetadata.put(EntityDataTypes.AREA_EFFECT_CLOUD_RADIUS, Float.valueOf(value));
        this.dirtyMetadata.put(EntityDataTypes.WIDTH, Float.valueOf(2.0f * value));
    }

    public void setParticle(EntityMetadata<Particle, ?> entityMetadata) {
        Particle particle = entityMetadata.getValue();
        Registries.PARTICLES.map(particle.getType(), p -> {
            ParticleType particleType;
            LevelEventType patt3337$temp = p.levelEventType();
            return patt3337$temp instanceof ParticleType ? (particleType = (ParticleType)patt3337$temp) : null;
        }).ifPresent(type -> this.dirtyMetadata.put(EntityDataTypes.AREA_EFFECT_CLOUD_PARTICLE, type));
        ParticleData particleData = particle.getData();
        if (particleData instanceof ColorParticleData) {
            ColorParticleData effectParticleData = (ColorParticleData)particleData;
            this.dirtyMetadata.put(EntityDataTypes.EFFECT_COLOR, effectParticleData.getColor());
        }
    }
}

