/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.api.entity.type;

import java.util.UUID;
import java.util.function.Consumer;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.api.entity.data.GeyserEntityDataType;
import org.geysermc.geyser.api.entity.definition.GeyserEntityDefinition;
import org.geysermc.geyser.api.entity.property.BatchPropertyUpdater;
import org.geysermc.geyser.api.entity.property.GeyserEntityProperty;

public interface GeyserEntity {
    public @NonNegative int javaId();

    public @Positive long geyserId();

    public @Nullable UUID uuid();

    public @NonNull GeyserEntityDefinition definition();

    public @NonNull Vector3f position();

    public <T> @Nullable T value(@NonNull GeyserEntityDataType<T> var1);

    public <T> void update(@NonNull GeyserEntityDataType<T> var1, @Nullable T var2);

    default public <T> void updateProperty(@NonNull GeyserEntityProperty<T> property, @Nullable T value) {
        this.updatePropertiesBatched(consumer -> consumer.update(property, value));
    }

    @Deprecated
    default public void updatePropertiesBatched(Consumer<BatchPropertyUpdater> consumer) {
        this.updatePropertiesBatched(consumer, false);
    }

    public void updatePropertiesBatched(Consumer<BatchPropertyUpdater> var1, boolean var2);
}

