/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.cumulus.form.impl.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.cumulus.component.ButtonComponent;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.form.impl.FormImpl;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;

public final class SimpleFormImpl
extends FormImpl<SimpleFormResponse>
implements SimpleForm {
    private final String content;
    private final List<ButtonComponent> buttons;

    public SimpleFormImpl(@NonNull String title, @NonNull String content, @NonNull List<ButtonComponent> buttons) {
        super(title);
        this.content = Objects.requireNonNull(content, "content");
        this.buttons = Collections.unmodifiableList(buttons);
    }

    @Override
    public @NonNull String content() {
        return this.content;
    }

    @Override
    public @NonNull List<ButtonComponent> buttons() {
        return this.buttons;
    }

    public static final class Builder
    extends FormImpl.Builder<SimpleForm.Builder, SimpleForm, SimpleFormResponse>
    implements SimpleForm.Builder {
        private final List<ButtonComponent> buttons = new ArrayList<ButtonComponent>();
        private String content = "";

        @Override
        public Builder content(@NonNull String content) {
            this.content = this.translate(Objects.requireNonNull(content, "content"));
            return this;
        }

        @Override
        public Builder button(@NonNull ButtonComponent button) {
            this.buttons.add(Objects.requireNonNull(button, "button"));
            return this;
        }

        @Override
        public Builder button(@NonNull String text, @NonNull FormImage.Type type, @NonNull String data) {
            this.buttons.add(ButtonComponent.of(this.translate(text), type, data));
            return this;
        }

        @Override
        public Builder button(@NonNull String text, @Nullable FormImage image) {
            this.buttons.add(ButtonComponent.of(this.translate(text), image));
            return this;
        }

        @Override
        public Builder button(@NonNull String text) {
            this.buttons.add(ButtonComponent.of(this.translate(text)));
            return this;
        }

        @Override
        public Builder optionalButton(@NonNull String text, @NonNull FormImage.Type type, @NonNull String data, boolean shouldAdd) {
            if (shouldAdd) {
                return this.button(text, type, data);
            }
            return this.addNullButton();
        }

        @Override
        public Builder optionalButton(@NonNull String text, @Nullable FormImage image, boolean shouldAdd) {
            if (shouldAdd) {
                return this.button(text, image);
            }
            return this.addNullButton();
        }

        @Override
        public Builder optionalButton(@NonNull String text, boolean shouldAdd) {
            if (shouldAdd) {
                return this.button(text);
            }
            return this.addNullButton();
        }

        @Override
        public @NonNull SimpleForm build() {
            SimpleFormImpl form = new SimpleFormImpl(this.title, this.content, this.buttons);
            this.setResponseHandler(form, form);
            return form;
        }

        private Builder addNullButton() {
            this.buttons.add(null);
            return this;
        }
    }
}

