/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.data.definitions;

import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemVersion;

public class SimpleItemDefinition
implements ItemDefinition {
    private final String identifier;
    private final int runtimeId;
    private final ItemVersion version;
    private final boolean componentBased;
    private final NbtMap componentData;

    public SimpleItemDefinition(String identifier, int runtimeId, boolean componentBased) {
        this.identifier = identifier;
        this.runtimeId = runtimeId;
        this.componentBased = componentBased;
        this.version = ItemVersion.LEGACY;
        this.componentData = null;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getRuntimeId() {
        return this.runtimeId;
    }

    @Override
    public ItemVersion getVersion() {
        return this.version;
    }

    @Override
    public boolean isComponentBased() {
        return this.componentBased;
    }

    @Override
    public NbtMap getComponentData() {
        return this.componentData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleItemDefinition)) {
            return false;
        }
        SimpleItemDefinition other = (SimpleItemDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRuntimeId() != other.getRuntimeId()) {
            return false;
        }
        if (this.isComponentBased() != other.isComponentBased()) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        ItemVersion this$version = this.getVersion();
        ItemVersion other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)((Object)this$version)).equals((Object)other$version)) {
            return false;
        }
        NbtMap this$componentData = this.getComponentData();
        NbtMap other$componentData = other.getComponentData();
        return !(this$componentData == null ? other$componentData != null : !((Object)this$componentData).equals(other$componentData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleItemDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRuntimeId();
        result = result * 59 + (this.isComponentBased() ? 79 : 97);
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        ItemVersion $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)((Object)$version)).hashCode());
        NbtMap $componentData = this.getComponentData();
        result = result * 59 + ($componentData == null ? 43 : ((Object)$componentData).hashCode());
        return result;
    }

    public String toString() {
        return "SimpleItemDefinition(identifier=" + this.getIdentifier() + ", runtimeId=" + this.getRuntimeId() + ", version=" + (Object)((Object)this.getVersion()) + ", componentBased=" + this.isComponentBased() + ", componentData=" + this.getComponentData() + ")";
    }

    public SimpleItemDefinition(String identifier, int runtimeId, ItemVersion version, boolean componentBased, NbtMap componentData) {
        this.identifier = identifier;
        this.runtimeId = runtimeId;
        this.version = version;
        this.componentBased = componentBased;
        this.componentData = componentData;
    }
}

