/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.imaginary;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.math.imaginary.Complexf;
import org.cloudburstmc.math.imaginary.Imaginary;
import org.cloudburstmc.math.imaginary.Imaginaryf;
import org.cloudburstmc.math.imaginary.Quaterniond;
import org.cloudburstmc.math.matrix.Matrix3f;
import org.cloudburstmc.math.vector.Vector3f;

@ParametersAreNonnullByDefault
public abstract class Quaternionf
implements Imaginaryf,
Comparable<Quaternionf>,
Serializable,
Cloneable {
    public static final Quaternionf ZERO = Quaternionf.from(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Quaternionf IDENTITY = Quaternionf.from(0.0f, 0.0f, 0.0f, 1.0f);

    public abstract float getX();

    public abstract float getY();

    public abstract float getZ();

    public abstract float getW();

    @Nonnull
    public Quaternionf add(Quaternionf q) {
        return this.add(q.getX(), q.getY(), q.getZ(), q.getW());
    }

    @Nonnull
    public Quaternionf add(double x, double y, double z, double w) {
        return this.add((float)x, (float)y, (float)z, (float)w);
    }

    @Nonnull
    public abstract Quaternionf add(float var1, float var2, float var3, float var4);

    @Nonnull
    public Quaternionf sub(Quaternionf q) {
        return this.sub(q.getX(), q.getY(), q.getZ(), q.getW());
    }

    @Nonnull
    public Quaternionf sub(double x, double y, double z, double w) {
        return this.sub((float)x, (float)y, (float)z, (float)w);
    }

    @Nonnull
    public abstract Quaternionf sub(float var1, float var2, float var3, float var4);

    @Nonnull
    public Quaternionf mul(double a) {
        return this.mul((float)a);
    }

    @Override
    @Nonnull
    public abstract Quaternionf mul(float var1);

    @Nonnull
    public Quaternionf mul(Quaternionf q) {
        return this.mul(q.getX(), q.getY(), q.getZ(), q.getW());
    }

    @Nonnull
    public Quaternionf mul(double x, double y, double z, double w) {
        return this.mul((float)x, (float)y, (float)z, (float)w);
    }

    @Nonnull
    public abstract Quaternionf mul(float var1, float var2, float var3, float var4);

    @Nonnull
    public Quaternionf div(double a) {
        return this.div((float)a);
    }

    @Override
    @Nonnull
    public abstract Quaternionf div(float var1);

    @Nonnull
    public Quaternionf div(Quaternionf q) {
        return this.div(q.getX(), q.getY(), q.getZ(), q.getW());
    }

    @Nonnull
    public Quaternionf div(double x, double y, double z, double w) {
        return this.div((float)x, (float)y, (float)z, (float)w);
    }

    @Nonnull
    public abstract Quaternionf div(float var1, float var2, float var3, float var4);

    public float dot(Quaternionf q) {
        return this.dot(q.getX(), q.getY(), q.getZ(), q.getW());
    }

    public float dot(double x, double y, double z, double w) {
        return this.dot((float)x, (float)y, (float)z, (float)w);
    }

    public float dot(float x, float y, float z, float w) {
        return this.getX() * x + this.getY() * y + this.getZ() * z + this.getW() * w;
    }

    @Nonnull
    public Vector3f rotate(Vector3f v) {
        return this.rotate(v.getX(), v.getY(), v.getZ());
    }

    @Nonnull
    public Vector3f rotate(double x, double y, double z) {
        return this.rotate((float)x, (float)y, (float)z);
    }

    @Nonnull
    public Vector3f rotate(float x, float y, float z) {
        float length = this.length();
        if (Math.abs(length) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot rotate by the zero quaternion");
        }
        float nx = this.getX() / length;
        float ny = this.getY() / length;
        float nz = this.getZ() / length;
        float nw = this.getW() / length;
        float px = nw * x + ny * z - nz * y;
        float py = nw * y + nz * x - nx * z;
        float pz = nw * z + nx * y - ny * x;
        float pw = -nx * x - ny * y - nz * z;
        return Vector3f.from(pw * -nx + px * nw - py * nz + pz * ny, pw * -ny + py * nw - pz * nx + px * nz, pw * -nz + pz * nw - px * ny + py * nx);
    }

    @Nonnull
    public Vector3f getDirection() {
        return this.rotate(Vector3f.FORWARD);
    }

    @Nonnull
    public Vector3f getAxis() {
        float q = (float)Math.sqrt(1.0f - this.getW() * this.getW());
        return Vector3f.from(this.getX() / q, this.getY() / q, this.getZ() / q);
    }

    @Nonnull
    public Vector3f getAxesAnglesDeg() {
        return this.getAxesAnglesRad().mul(57.29577951308232);
    }

    @Nonnull
    public Vector3f getAxesAnglesRad() {
        double yaw;
        double pitch;
        double roll;
        double test = this.getW() * this.getX() - this.getY() * this.getZ();
        if (Math.abs(test) < 0.4999) {
            roll = TrigMath.atan2(2.0f * (this.getW() * this.getZ() + this.getX() * this.getY()), 1.0f - 2.0f * (this.getX() * this.getX() + this.getZ() * this.getZ()));
            pitch = TrigMath.asin(2.0 * test);
            yaw = TrigMath.atan2(2.0f * (this.getW() * this.getY() + this.getZ() * this.getX()), 1.0f - 2.0f * (this.getX() * this.getX() + this.getY() * this.getY()));
        } else {
            int sign = test < 0.0 ? -1 : 1;
            roll = 0.0;
            pitch = (double)sign * Math.PI / 2.0;
            yaw = (double)(-sign * 2) * TrigMath.atan2(this.getZ(), this.getW());
        }
        return Vector3f.from(pitch, yaw, roll);
    }

    @Override
    @Nonnull
    public abstract Quaternionf conjugate();

    @Override
    @Nonnull
    public abstract Quaternionf invert();

    @Override
    public float lengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ() + this.getW() * this.getW();
    }

    @Override
    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    @Override
    @Nonnull
    public abstract Quaternionf normalize();

    @Nonnull
    public Complexf toComplex() {
        float w2 = this.getW() * this.getW();
        return Complexf.from(2.0f * w2 - 1.0f, 2.0f * this.getW() * (float)Math.sqrt(1.0f - w2));
    }

    @Override
    @Nonnull
    public Quaternionf toFloat() {
        return Quaternionf.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    @Nonnull
    public Quaterniond toDouble() {
        return Quaterniond.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    public int compareTo(Quaternionf q) {
        return (int)Math.signum(this.lengthSquared() - q.lengthSquared());
    }

    @Nonnull
    public Quaternionf clone() {
        return Quaternionf.from(this);
    }

    @Nonnull
    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ", " + this.getW() + ")";
    }

    @Nonnull
    public static Quaternionf fromReal(float w) {
        return Imaginary.createQuaternionf(0.0f, 0.0f, 0.0f, w);
    }

    @Nonnull
    public static Quaternionf fromImaginary(float x, float y, float z) {
        return Imaginary.createQuaternionf(x, y, z, 0.0f);
    }

    public static Quaternionf from(Quaternionf q) {
        return Quaternionf.from(q.getX(), q.getY(), q.getZ(), q.getW());
    }

    @Nonnull
    public static Quaternionf from(double x, double y, double z, double w) {
        return Quaternionf.from((float)x, (float)y, (float)z, (float)w);
    }

    @Nonnull
    public static Quaternionf from(float x, float y, float z, float w) {
        return Imaginary.createQuaternionf(x, y, z, w);
    }

    @Nonnull
    public static Quaternionf fromAxesAnglesDeg(double pitch, double yaw, double roll) {
        return Quaternionf.fromAxesAnglesDeg((float)pitch, (float)yaw, (float)roll);
    }

    @Nonnull
    public static Quaternionf fromAxesAnglesRad(double pitch, double yaw, double roll) {
        return Quaternionf.fromAxesAnglesRad((float)pitch, (float)yaw, (float)roll);
    }

    @Nonnull
    public static Quaternionf fromAxesAnglesDeg(float pitch, float yaw, float roll) {
        return Quaternionf.fromAngleDegAxis(yaw, Vector3f.UNIT_Y).mul(Quaternionf.fromAngleDegAxis(pitch, Vector3f.UNIT_X)).mul(Quaternionf.fromAngleDegAxis(roll, Vector3f.UNIT_Z));
    }

    @Nonnull
    public static Quaternionf fromAxesAnglesRad(float pitch, float yaw, float roll) {
        return Quaternionf.fromAngleRadAxis(yaw, Vector3f.UNIT_Y).mul(Quaternionf.fromAngleRadAxis(pitch, Vector3f.UNIT_X)).mul(Quaternionf.fromAngleRadAxis(roll, Vector3f.UNIT_Z));
    }

    @Nonnull
    public static Quaternionf fromRotationTo(Vector3f from, Vector3f to) {
        return Quaternionf.fromAngleRadAxis(TrigMath.acos(from.dot(to) / (from.length() * to.length())), from.cross(to));
    }

    @Nonnull
    public static Quaternionf fromAngleDegAxis(double angle, Vector3f axis) {
        return Quaternionf.fromAngleRadAxis(Math.toRadians(angle), axis);
    }

    @Nonnull
    public static Quaternionf fromAngleRadAxis(double angle, Vector3f axis) {
        return Quaternionf.fromAngleRadAxis((float)angle, axis);
    }

    @Nonnull
    public static Quaternionf fromAngleDegAxis(float angle, Vector3f axis) {
        return Quaternionf.fromAngleRadAxis((float)Math.toRadians(angle), axis);
    }

    @Nonnull
    public static Quaternionf fromAngleRadAxis(float angle, Vector3f axis) {
        return Quaternionf.fromAngleRadAxis(angle, axis.getX(), axis.getY(), axis.getZ());
    }

    @Nonnull
    public static Quaternionf fromAngleDegAxis(double angle, double x, double y, double z) {
        return Quaternionf.fromAngleRadAxis(Math.toRadians(angle), x, y, z);
    }

    @Nonnull
    public static Quaternionf fromAngleRadAxis(double angle, double x, double y, double z) {
        return Quaternionf.fromAngleRadAxis((float)angle, (float)x, (float)y, (float)z);
    }

    @Nonnull
    public static Quaternionf fromAngleDegAxis(float angle, float x, float y, float z) {
        return Quaternionf.fromAngleRadAxis((float)Math.toRadians(angle), x, y, z);
    }

    @Nonnull
    public static Quaternionf fromAngleRadAxis(float angle, float x, float y, float z) {
        float halfAngle = angle / 2.0f;
        float q = TrigMath.sin(halfAngle) / (float)Math.sqrt(x * x + y * y + z * z);
        return Quaternionf.from(x * q, y * q, z * q, TrigMath.cos(halfAngle));
    }

    @Nonnull
    public static Quaternionf fromRotationMatrix(Matrix3f matrix) {
        float trace = matrix.trace();
        if (trace < 0.0f) {
            if (matrix.get(1, 1) > matrix.get(0, 0)) {
                if (matrix.get(2, 2) > matrix.get(1, 1)) {
                    float r = (float)Math.sqrt(matrix.get(2, 2) - matrix.get(0, 0) - matrix.get(1, 1) + 1.0f);
                    float s = 0.5f / r;
                    return Quaternionf.from((matrix.get(2, 0) + matrix.get(0, 2)) * s, (matrix.get(1, 2) + matrix.get(2, 1)) * s, 0.5f * r, (matrix.get(1, 0) - matrix.get(0, 1)) * s);
                }
                float r = (float)Math.sqrt(matrix.get(1, 1) - matrix.get(2, 2) - matrix.get(0, 0) + 1.0f);
                float s = 0.5f / r;
                return Quaternionf.from((matrix.get(0, 1) + matrix.get(1, 0)) * s, 0.5f * r, (matrix.get(1, 2) + matrix.get(2, 1)) * s, (matrix.get(0, 2) - matrix.get(2, 0)) * s);
            }
            if (matrix.get(2, 2) > matrix.get(0, 0)) {
                float r = (float)Math.sqrt(matrix.get(2, 2) - matrix.get(0, 0) - matrix.get(1, 1) + 1.0f);
                float s = 0.5f / r;
                return Quaternionf.from((matrix.get(2, 0) + matrix.get(0, 2)) * s, (matrix.get(1, 2) + matrix.get(2, 1)) * s, 0.5f * r, (matrix.get(1, 0) - matrix.get(0, 1)) * s);
            }
            float r = (float)Math.sqrt(matrix.get(0, 0) - matrix.get(1, 1) - matrix.get(2, 2) + 1.0f);
            float s = 0.5f / r;
            return Quaternionf.from(0.5f * r, (matrix.get(0, 1) + matrix.get(1, 0)) * s, (matrix.get(2, 0) - matrix.get(0, 2)) * s, (matrix.get(2, 1) - matrix.get(1, 2)) * s);
        }
        float r = (float)Math.sqrt(trace + 1.0f);
        float s = 0.5f / r;
        return Quaternionf.from((matrix.get(2, 1) - matrix.get(1, 2)) * s, (matrix.get(0, 2) - matrix.get(2, 0)) * s, (matrix.get(1, 0) - matrix.get(0, 1)) * s, 0.5f * r);
    }
}

