/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient.content.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.annotation.Nonnull;
import net.lenni0451.commons.httpclient.constants.ContentTypes;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.model.ContentType;

public class ByteArrayContent
extends HttpContent {
    private final byte[] content;
    private final int start;
    private final int length;

    public ByteArrayContent(byte[] content) {
        this(content, 0, content.length);
    }

    public ByteArrayContent(byte[] content, int start, int length) {
        super(ContentTypes.APPLICATION_OCTET_STREAM);
        this.content = content;
        this.start = start;
        this.length = length;
    }

    public ByteArrayContent(ContentType contentType, byte[] content) {
        this(contentType, content, 0, content.length);
    }

    public ByteArrayContent(ContentType contentType, byte[] content, int start, int length) {
        super(contentType);
        this.content = content;
        this.start = start;
        this.length = length;
    }

    @Override
    public boolean canBeStreamedMultipleTimes() {
        return true;
    }

    @Override
    public int getLength() {
        return this.content.length;
    }

    @Override
    @Nonnull
    protected InputStream compute() {
        return new ByteArrayInputStream(this.content, this.start, this.length);
    }
}

