/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.natives;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public class NativeCode<T>
implements Supplier<T> {
    private final Variant<T>[] variants;
    private final Variant<T> loadedVariant;

    @SafeVarargs
    public NativeCode(Variant<T> ... variants) {
        Objects.requireNonNull(variants, "variants");
        if (variants.length < 2) {
            throw new IllegalArgumentException("At least 2 variants must be specified");
        }
        for (Variant<T> variant : this.variants = variants) {
            if (!((Variant)variant).availability.getAsBoolean()) continue;
            this.loadedVariant = variant;
            return;
        }
        throw new IllegalStateException("No variants were able to load");
    }

    @Override
    public T get() {
        return ((Variant)this.loadedVariant).factory.get();
    }

    public String getVariantName() {
        return ((Variant)this.loadedVariant).name;
    }

    public Variant<T>[] getVariants() {
        return this.variants;
    }

    public static class Variant<T> {
        private final String name;
        private final BooleanSupplier availability;
        private final Supplier<T> factory;

        public Variant(String name, BooleanSupplier availability, Supplier<T> factory) {
            this.name = name;
            this.availability = availability;
            this.factory = factory;
        }
    }
}

