/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity.player;

import java.util.Arrays;
import org.cloudburstmc.protocol.bedrock.data.AttributeData;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.player.ClientboundSetExperiencePacket;

@Translator(packet=ClientboundSetExperiencePacket.class)
public class JavaSetExperienceTranslator
extends PacketTranslator<ClientboundSetExperiencePacket> {
    @Override
    public void translate(GeyserSession session, ClientboundSetExperiencePacket packet) {
        SessionPlayerEntity entity = session.getPlayerEntity();
        AttributeData experience = GeyserAttributeType.EXPERIENCE.getAttribute(packet.getExperience());
        entity.getAttributes().put(GeyserAttributeType.EXPERIENCE, experience);
        AttributeData experienceLevel = GeyserAttributeType.EXPERIENCE_LEVEL.getAttribute(packet.getLevel());
        entity.getAttributes().put(GeyserAttributeType.EXPERIENCE_LEVEL, experienceLevel);
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(session.getPlayerEntity().geyserId());
        attributesPacket.setAttributes(Arrays.asList(experience, experienceLevel));
        session.sendUpstreamPacket((BedrockPacket)attributesPacket);
    }
}

