/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity.player;

import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.ChunkRadiusUpdatedPacket;
import org.cloudburstmc.protocol.bedrock.packet.MovePlayerPacket;
import org.cloudburstmc.protocol.bedrock.packet.RespawnPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityMotionPacket;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.TeleportCache;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PositionElement;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.player.ClientboundPlayerPositionPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level.ServerboundAcceptTeleportationPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerPosRotPacket;

@Translator(packet=ClientboundPlayerPositionPacket.class)
public class JavaPlayerPositionTranslator
extends PacketTranslator<ClientboundPlayerPositionPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundPlayerPositionPacket packet) {
        if (!session.isLoggedIn()) {
            return;
        }
        SessionPlayerEntity entity = session.getPlayerEntity();
        Vector3d position = packet.getPosition().add(packet.getRelatives().contains(PositionElement.X) ? entity.position().getX() : 0.0f, packet.getRelatives().contains(PositionElement.Y) ? entity.position().getY() : 0.0f, packet.getRelatives().contains(PositionElement.Z) ? entity.position().getZ() : 0.0f);
        float newPitch = MathUtils.clamp(packet.getXRot() + (packet.getRelatives().contains(PositionElement.X_ROT) ? entity.getPitch() : 0.0f), -90.0f, 90.0f);
        float newYaw = packet.getYRot() + (packet.getRelatives().contains(PositionElement.Y_ROT) ? entity.getYaw() : 0.0f);
        int teleportId = packet.getId();
        this.acceptTeleport(session, position, newYaw, newPitch, teleportId);
        if (!session.isSpawned()) {
            entity.setPosition(position.toFloat());
            entity.setYaw(packet.getYRot());
            entity.setPitch(packet.getXRot());
            entity.setHeadYaw(packet.getYRot());
            RespawnPacket respawnPacket = new RespawnPacket();
            respawnPacket.setRuntimeEntityId(0L);
            respawnPacket.setPosition(entity.bedrockPosition());
            respawnPacket.setState(RespawnPacket.State.SERVER_READY);
            session.sendUpstreamPacket((BedrockPacket)respawnPacket);
            entity.updateBedrockMetadata();
            MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
            movePlayerPacket.setRuntimeEntityId(entity.geyserId());
            movePlayerPacket.setPosition(entity.bedrockPosition());
            movePlayerPacket.setRotation(entity.getBedrockRotation());
            movePlayerPacket.setMode(MovePlayerPacket.Mode.RESPAWN);
            session.sendUpstreamPacket((BedrockPacket)movePlayerPacket);
            entity.updateOwnRotation(entity.getYaw(), entity.getPitch(), entity.getHeadYaw());
            session.setSpawned(true);
            session.setUnconfirmedTeleport(new TeleportCache(entity.position(), packet.getXRot(), packet.getYRot(), packet.getId()));
            if (session.getServerRenderDistance() > 32 && !session.isEmulatePost1_13Logic()) {
                ChunkRadiusUpdatedPacket chunkRadiusUpdatedPacket = new ChunkRadiusUpdatedPacket();
                chunkRadiusUpdatedPacket.setRadius(session.getServerRenderDistance());
                session.sendUpstreamPacket((BedrockPacket)chunkRadiusUpdatedPacket);
                session.setLastChunkPosition(null);
            }
            ChunkUtils.updateChunkPosition(session, position.toInt());
            if (session.getGeyser().config().debugMode()) {
                session.getGeyser().getLogger().debug("Spawned player at " + String.valueOf(packet.getPosition()));
            }
            return;
        }
        Vector3f lastPlayerPosition = entity.position();
        session.getGeyser().getLogger().debug("Teleport (" + teleportId + ") from " + String.valueOf(lastPlayerPosition));
        float lastPlayerPitch = entity.getPitch();
        float lastPlayerYaw = entity.getYaw();
        Vector3f teleportDestination = position.toFloat();
        Vector3f deltaMovement = packet.getDeltaMovement().toFloat().add(packet.getRelatives().contains(PositionElement.DELTA_X) ? entity.getMotion().getX() : 0.0f, packet.getRelatives().contains(PositionElement.DELTA_Y) ? entity.getMotion().getY() : 0.0f, packet.getRelatives().contains(PositionElement.DELTA_Z) ? entity.getMotion().getZ() : 0.0f);
        if (packet.getRelatives().contains(PositionElement.ROTATE_DELTA)) {
            deltaMovement = MathUtils.xYRot(deltaMovement, (float)Math.toRadians(lastPlayerPitch - newPitch), (float)Math.toRadians(lastPlayerYaw - newYaw));
        }
        entity.moveAbsolute(teleportDestination, newYaw, newPitch, false, true);
        TeleportCache.TeleportType type = TeleportCache.TeleportType.NORMAL;
        if (deltaMovement.distanceSquared(Vector3f.ZERO) > 1.0E-8f) {
            entity.setMotion(deltaMovement);
            SetEntityMotionPacket entityMotionPacket = new SetEntityMotionPacket();
            entityMotionPacket.setRuntimeEntityId(entity.geyserId());
            entityMotionPacket.setMotion(entity.getMotion());
            session.sendUpstreamPacket((BedrockPacket)entityMotionPacket);
            type = TeleportCache.TeleportType.KEEP_VELOCITY;
        }
        if ((double)lastPlayerPosition.distanceSquared(teleportDestination) < 0.001 && Math.abs(newPitch - lastPlayerPitch) < 5.0f && Math.abs(newYaw - lastPlayerYaw) < 5.0f) {
            session.setUnconfirmedTeleport(null);
        } else {
            session.setUnconfirmedTeleport(new TeleportCache(teleportDestination, deltaMovement, newPitch, newYaw, teleportId, type));
        }
        session.getGeyser().getLogger().debug("to " + String.valueOf(entity.position()));
    }

    private void acceptTeleport(GeyserSession session, Vector3d position, float yaw, float pitch, int id) {
        ServerboundAcceptTeleportationPacket teleportConfirmPacket = new ServerboundAcceptTeleportationPacket(id);
        session.sendDownstreamGamePacket((Packet)teleportConfirmPacket);
        ServerboundMovePlayerPosRotPacket positionPacket = new ServerboundMovePlayerPosRotPacket(false, false, position.getX(), position.getY(), position.getZ(), yaw, pitch);
        session.sendDownstreamGamePacket((Packet)positionPacket);
    }
}

