/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity;

import org.geysermc.geyser.entity.EntityTypeDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundSetEntityDataPacket;

@Translator(packet=ClientboundSetEntityDataPacket.class)
public class JavaSetEntityDataTranslator
extends PacketTranslator<ClientboundSetEntityDataPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundSetEntityDataPacket packet) {
        Entity entity = session.getEntityCache().getEntityByJavaId(packet.getEntityId());
        if (entity == null) {
            return;
        }
        EntityTypeDefinition<?> definition = entity.getJavaTypeDefinition();
        for (EntityMetadata metadata : packet.getMetadata()) {
            if (metadata.getId() >= definition.translators().size()) {
                if (!session.getGeyser().config().debugMode()) continue;
                session.getGeyser().getLogger().warning("Metadata ID " + metadata.getId() + " is out of bounds of known entity metadata size " + definition.translators().size() + " for entity type " + String.valueOf(entity.getJavaTypeDefinition().type()));
                session.getGeyser().getLogger().debug(metadata.toString());
                continue;
            }
            definition.translateMetadata(entity, metadata);
        }
        entity.updateBedrockMetadata();
        Entity mouseoverEntity = session.getMouseoverEntity();
        if (mouseoverEntity != null && mouseoverEntity.getEntityId() == entity.getEntityId()) {
            mouseoverEntity.updateInteractiveTag();
        }
    }
}

