/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity;

import java.util.function.Consumer;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.EntityTypeDefinition;
import org.geysermc.geyser.entity.GeyserEntityType;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.FallingBlockEntity;
import org.geysermc.geyser.entity.type.FishingHookEntity;
import org.geysermc.geyser.entity.type.HangingEntity;
import org.geysermc.geyser.entity.type.player.AvatarEntity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.EnvironmentUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.FallingBlockData;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.ProjectileData;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.WardenData;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.BuiltinEntityType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundAddEntityPacket;

@Translator(packet=ClientboundAddEntityPacket.class)
public class JavaAddEntityTranslator
extends PacketTranslator<ClientboundAddEntityPacket> {
    private static final boolean SHOW_PLAYER_LIST_LOGS = Boolean.parseBoolean(System.getProperty("Geyser.ShowPlayerListLogs", "true"));

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void translate(GeyserSession session, ClientboundAddEntityPacket packet) {
        void var6_12;
        WardenData wardenData;
        GeyserEntityType type = GeyserEntityType.of(packet.getType());
        if (type.isUnregistered()) {
            session.getGeyser().getLogger().warning("Received unregistered entity type " + String.valueOf(type) + " in add entity packet");
            return;
        }
        EntityTypeDefinition definition = (EntityTypeDefinition)Registries.JAVA_ENTITY_TYPES.get(type);
        if (definition == null) {
            session.getGeyser().getLogger().debug("Could not find an entity definition for add entity packet " + String.valueOf(packet));
            return;
        }
        EntitySpawnContext context = EntitySpawnContext.fromPacket(session, definition, packet);
        if (type.is((EntityType)BuiltinEntityType.PLAYER)) {
            void var6_8;
            if (packet.getUuid().equals(session.getPlayerEntity().uuid())) {
                PlayerEntity playerEntity = new PlayerEntity(context, session.getPlayerEntity().getUsername(), session.getPlayerEntity().getTexturesProperty());
            } else {
                PlayerEntity playerEntity = session.getEntityCache().getPlayerEntity(packet.getUuid());
                if (playerEntity == null) {
                    if (!SHOW_PLAYER_LIST_LOGS) return;
                    GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.entity.player.failed_list", packet.getUuid()));
                    return;
                }
                playerEntity.setEntityId(packet.getEntityId());
                playerEntity.setPosition(context.position());
                playerEntity.setYaw(packet.getYaw());
                playerEntity.setPitch(packet.getPitch());
                playerEntity.setHeadYaw(packet.getHeadYaw());
                playerEntity.setMotion(packet.getMovement().toFloat());
            }
            var6_8.sendPlayer();
            if (EnvironmentUtils.IS_UNIT_TESTING) return;
            SkinManager.requestAndHandleSkinAndCape((AvatarEntity)var6_8, session, null);
            return;
        }
        if (!context.callServerSpawnEvent()) {
            GeyserImpl.getInstance().getLogger().debug(session, "Cancelled entity spawn (%s) at (%s)".formatted(type.identifier(), context.position()), new Object[0]);
            return;
        }
        if (type.is((EntityType)BuiltinEntityType.FALLING_BLOCK)) {
            FallingBlockEntity fallingBlockEntity = new FallingBlockEntity(context, ((FallingBlockData)packet.getData()).getId());
        } else if (type.is((EntityType)BuiltinEntityType.FISHING_BOBBER)) {
            int ownerEntityId = ((ProjectileData)packet.getData()).getOwnerId();
            Entity owner = session.getEntityCache().getEntityByJavaId(ownerEntityId);
            if (!(owner instanceof PlayerEntity)) return;
            FishingHookEntity fishingHookEntity = new FishingHookEntity(context, (PlayerEntity)owner);
        } else {
            Object t = definition.factory().create(context);
            if (t instanceof HangingEntity) {
                HangingEntity hanging = (HangingEntity)t;
                hanging.setDirection((Direction)packet.getData());
            }
        }
        if (type.is((EntityType)BuiltinEntityType.WARDEN) && (wardenData = (WardenData)packet.getData()).isEmerging()) {
            var6_12.setPose(Pose.EMERGING);
        }
        if (context.consumers() != null) {
            context.consumers().forEach(arg_0 -> JavaAddEntityTranslator.lambda$translate$0((Entity)var6_12, arg_0));
        }
        session.getEntityCache().spawnEntity((Entity)var6_12);
    }

    private static /* synthetic */ void lambda$translate$0(Entity entity, Consumer consumer) {
        consumer.accept(entity);
    }
}

