/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import org.cloudburstmc.protocol.bedrock.packet.LecternUpdatePacket;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.InventoryHolder;
import org.geysermc.geyser.inventory.LecternContainer;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundContainerButtonClickPacket;

@Translator(packet=LecternUpdatePacket.class)
public class BedrockLecternUpdateTranslator
extends PacketTranslator<LecternUpdatePacket> {
    @Override
    public void translate(GeyserSession session, LecternUpdatePacket packet) {
        Inventory inventory;
        InventoryHolder<? extends Inventory> holder = session.getInventoryHolder();
        if (holder == null || !((inventory = holder.inventory()) instanceof LecternContainer)) {
            session.getGeyser().getLogger().debug("Expected lectern but it wasn't open!");
            return;
        }
        LecternContainer lecternContainer = (LecternContainer)inventory;
        if (lecternContainer.getCurrentBedrockPage() == packet.getPage()) {
            InventoryUtils.sendJavaContainerClose(holder);
            InventoryUtils.closeInventory(session, holder, false);
        } else {
            int newJavaPage = packet.getPage() * 2;
            int currentJavaPage = lecternContainer.getCurrentBedrockPage() * 2;
            if (!lecternContainer.isUsingRealBlock()) {
                holder.updateProperty(0, newJavaPage);
                return;
            }
            if (newJavaPage > currentJavaPage) {
                for (int i = currentJavaPage; i < newJavaPage; ++i) {
                    ServerboundContainerButtonClickPacket clickButtonPacket = new ServerboundContainerButtonClickPacket(lecternContainer.getJavaId(), 2);
                    session.sendDownstreamGamePacket((Packet)clickButtonPacket);
                }
            } else {
                for (int i = currentJavaPage; i > newJavaPage; --i) {
                    ServerboundContainerButtonClickPacket clickButtonPacket = new ServerboundContainerButtonClickPacket(lecternContainer.getJavaId(), 1);
                    session.sendDownstreamGamePacket((Packet)clickButtonPacket);
                }
            }
        }
    }
}

