/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.ContainerOpenPacket;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Generic3X3Container;
import org.geysermc.geyser.inventory.updater.ContainerInventoryUpdater;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;

public class Generic3X3InventoryTranslator
extends AbstractBlockInventoryTranslator<Generic3X3Container> {
    public Generic3X3InventoryTranslator() {
        super(9, Blocks.DISPENSER, ContainerType.DISPENSER, (InventoryUpdater)ContainerInventoryUpdater.INSTANCE, Blocks.DROPPER);
    }

    @Override
    public Generic3X3Container createInventory(GeyserSession session, String name, int windowId, org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType containerType) {
        return new Generic3X3Container(session, name, windowId, this.size, containerType);
    }

    @Override
    public void openInventory(GeyserSession session, Generic3X3Container container) {
        ContainerOpenPacket containerOpenPacket = new ContainerOpenPacket();
        containerOpenPacket.setId((byte)container.getBedrockId());
        containerOpenPacket.setType(container.isDropper() ? ContainerType.DROPPER : ContainerType.DISPENSER);
        containerOpenPacket.setBlockPosition(container.getHolderPosition());
        containerOpenPacket.setUniqueEntityId(container.getHolderId());
        session.sendUpstreamPacket((BedrockPacket)containerOpenPacket);
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int javaSlot, Generic3X3Container container) {
        if (javaSlot < this.size) {
            return new BedrockContainerSlot(ContainerSlotType.LEVEL_ENTITY, javaSlot);
        }
        return super.javaSlotToBedrockContainer(javaSlot, container);
    }

    @Override
    public ContainerType closeContainerType(Generic3X3Container container) {
        return container.isDropper() ? ContainerType.DROPPER : ContainerType.DISPENSER;
    }
}

