/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.collision.fixes;

import lombok.Generated;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.CollisionRemapper;

@CollisionRemapper(regex="_door$", usesParams=true, passDefaultBoxes=true)
public class DoorCollision
extends BlockCollision {
    private static final double MAX_PUSH_DISTANCE = 0.0050101;
    private final int facing;

    public DoorCollision(BlockState state, BoundingBox[] defaultBoxes) {
        super(defaultBoxes);
        Direction direction = state.getValue(Properties.HORIZONTAL_FACING);
        if (state.getValue(Properties.OPEN).booleanValue()) {
            direction = state.getValue(Properties.DOOR_HINGE).equals("right") ? direction.counterClockWise() : direction.clockWise();
        }
        this.facing = switch (direction) {
            case Direction.NORTH -> 1;
            case Direction.EAST -> 2;
            case Direction.SOUTH -> 3;
            case Direction.WEST -> 4;
            default -> throw new IllegalStateException();
        };
    }

    @Override
    protected void correctPosition(GeyserSession session, int x, int y, int z, BoundingBox blockCollision, BoundingBox playerCollision) {
        switch (this.facing) {
            case 1: {
                blockCollision.pushOutOfBoundingBox(playerCollision, Direction.NORTH, 0.0050101);
                break;
            }
            case 2: {
                blockCollision.pushOutOfBoundingBox(playerCollision, Direction.EAST, 0.0050101);
                break;
            }
            case 3: {
                blockCollision.pushOutOfBoundingBox(playerCollision, Direction.SOUTH, 0.0050101);
                break;
            }
            case 4: {
                blockCollision.pushOutOfBoundingBox(playerCollision, Direction.WEST, 0.0050101);
            }
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoorCollision)) {
            return false;
        }
        DoorCollision other = (DoorCollision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.facing == other.facing;
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DoorCollision;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.facing;
        return result;
    }
}

