/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.mod.mixin.server;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.PistonCache;
import org.geysermc.geyser.translator.level.block.entity.PistonBlockEntity;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.PistonValueType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PistonBaseBlock.class})
public class PistonBaseBlockMixin {
    @Shadow
    @Final
    private boolean isSticky;

    @ModifyExpressionValue(method={"moveBlocks(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;Z)Z"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/Maps;newHashMap()Ljava/util/HashMap;")})
    private HashMap<BlockPos, BlockState> geyser$onMapCreate(HashMap<BlockPos, BlockState> original, @Share(value="pushBlocks") LocalRef<Map<BlockPos, BlockState>> localRef) {
        localRef.set(original);
        return original;
    }

    @Inject(method={"moveBlocks(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;Z)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/piston/PistonStructureResolver;getToDestroy()Ljava/util/List;")})
    private void geyser$onBlocksMove(Level level, BlockPos blockPos, net.minecraft.core.Direction direction, boolean isExtending, CallbackInfoReturnable<Boolean> cir, @Share(value="pushBlocks") LocalRef<Map<BlockPos, BlockState>> localRef) {
        PistonValueType type = isExtending ? PistonValueType.PUSHING : PistonValueType.PULLING;
        boolean sticky = this.isSticky;
        Object2ObjectArrayMap attachedBlocks = new Object2ObjectArrayMap();
        boolean blocksFilled = false;
        for (Map.Entry<UUID, GeyserSession> entry : GeyserImpl.getInstance().getSessionManager().getSessions().entrySet()) {
            int dZ;
            Player player = level.getPlayerByUUID(entry.getKey());
            if (player == null || !player.level().equals(level)) continue;
            GeyserSession session = entry.getValue();
            int dX = Math.abs(blockPos.getX() - player.getBlockX()) >> 4;
            if (dX * dX + (dZ = Math.abs(blockPos.getZ() - player.getBlockZ()) >> 4) * dZ > session.getServerRenderDistance() * session.getServerRenderDistance()) continue;
            if (!blocksFilled) {
                Map blocks = (Map)localRef.get();
                for (Map.Entry blockStateEntry : blocks.entrySet()) {
                    int blockStateId = Block.BLOCK_STATE_REGISTRY.getId((Object)((BlockState)blockStateEntry.getValue()));
                    org.geysermc.geyser.level.block.type.BlockState state = org.geysermc.geyser.level.block.type.BlockState.of(blockStateId);
                    attachedBlocks.put((Object)PistonBaseBlockMixin.geyser$fromBlockPos((BlockPos)blockStateEntry.getKey()), (Object)state);
                }
                blocksFilled = true;
            }
            Direction orientation = Direction.VALUES[direction.ordinal()];
            Vector3i position = PistonBaseBlockMixin.geyser$fromBlockPos(blockPos);
            session.executeInEventLoop(() -> PistonBaseBlockMixin.lambda$geyser$onBlocksMove$1(session, position, orientation, sticky, isExtending, type, (Object2ObjectMap)attachedBlocks));
        }
    }

    @Unique
    private static Vector3i geyser$fromBlockPos(BlockPos pos) {
        return Vector3i.from((int)pos.getX(), (int)pos.getY(), (int)pos.getZ());
    }

    private static /* synthetic */ void lambda$geyser$onBlocksMove$1(GeyserSession session, Vector3i position, Direction orientation, boolean sticky, boolean isExtending, PistonValueType type, Object2ObjectMap attachedBlocks) {
        PistonCache pistonCache = session.getPistonCache();
        PistonBlockEntity blockEntity = pistonCache.getPistons().computeIfAbsent(position, pos -> new PistonBlockEntity(session, position, orientation, sticky, !isExtending));
        blockEntity.setAction(type, (Map<Vector3i, org.geysermc.geyser.level.block.type.BlockState>)attachedBlocks);
    }
}

