/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.BundleCache;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.EmptySlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.ItemSlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.ItemStackSlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.SlotDisplay;

public class GeyserItemStack {
    public static final GeyserItemStack EMPTY = new GeyserItemStack(Items.AIR_ID, 0, null);
    private final int javaId;
    private int amount;
    private DataComponents components;
    private int netId;
    private BundleCache.BundleData bundleData;
    private Item item;

    private GeyserItemStack(int javaId, int amount, DataComponents components) {
        this(javaId, amount, components, 1, null);
    }

    private GeyserItemStack(int javaId, int amount, DataComponents components, int netId, BundleCache.BundleData bundleData) {
        this.javaId = javaId;
        this.amount = amount;
        this.components = components;
        this.netId = netId;
        this.bundleData = bundleData;
    }

    public static @NonNull GeyserItemStack of(int javaId, int amount) {
        return GeyserItemStack.of(javaId, amount, null);
    }

    public static @NonNull GeyserItemStack of(int javaId, int amount, @Nullable DataComponents components) {
        return new GeyserItemStack(javaId, amount, components);
    }

    public static @NonNull GeyserItemStack from(@Nullable ItemStack itemStack) {
        return itemStack == null ? EMPTY : new GeyserItemStack(itemStack.getId(), itemStack.getAmount(), itemStack.getDataComponentsPatch());
    }

    public static @NonNull GeyserItemStack from(@NonNull SlotDisplay slotDisplay) {
        if (slotDisplay instanceof EmptySlotDisplay) {
            return EMPTY;
        }
        if (slotDisplay instanceof ItemSlotDisplay) {
            ItemSlotDisplay itemSlotDisplay = (ItemSlotDisplay)slotDisplay;
            return GeyserItemStack.of(itemSlotDisplay.item(), 1);
        }
        if (slotDisplay instanceof ItemStackSlotDisplay) {
            ItemStackSlotDisplay itemStackSlotDisplay = (ItemStackSlotDisplay)slotDisplay;
            return GeyserItemStack.from(itemStackSlotDisplay.itemStack());
        }
        GeyserImpl.getInstance().getLogger().warning("Unsure how to convert to ItemStack: " + String.valueOf(slotDisplay));
        return EMPTY;
    }

    public int getJavaId() {
        return this.isEmpty() ? 0 : this.javaId;
    }

    public int getAmount() {
        return this.isEmpty() ? 0 : this.amount;
    }

    public boolean is(Item item) {
        return this.javaId == item.javaId();
    }

    public boolean is(GeyserSession session, Tag<Item> tag) {
        return session.getTagCache().is(tag, this.javaId);
    }

    public boolean is(GeyserSession session, HolderSet set) {
        return session.getTagCache().is(set, JavaRegistries.ITEM, this.javaId);
    }

    public boolean isSameItem(GeyserItemStack other) {
        return this.javaId == other.javaId;
    }

    public @Nullable DataComponents getAllComponents() {
        return this.isEmpty() ? null : this.asItem().gatherComponents(this.components);
    }

    public @Nullable DataComponents getComponents() {
        return this.isEmpty() ? null : this.components;
    }

    public boolean hasNonBaseComponents() {
        return this.components != null;
    }

    public @NonNull DataComponents getOrCreateComponents() {
        if (this.components == null) {
            this.components = new DataComponents(new HashMap());
            return this.components;
        }
        return this.components;
    }

    public <T> @Nullable T getComponent(@NonNull DataComponentType<T> type) {
        if (this.components != null && this.components.contains(type)) {
            return (T)this.components.get(type);
        }
        return this.asItem().getComponent(type);
    }

    public <T> T getComponentElseGet(@NonNull DataComponentType<T> type, Supplier<T> supplier) {
        T value = this.getComponent(type);
        return value == null ? supplier.get() : value;
    }

    public int getNetId() {
        return this.isEmpty() ? 0 : this.netId;
    }

    public int getBundleId() {
        if (this.isEmpty()) {
            return -1;
        }
        return this.bundleData == null ? -1 : this.bundleData.bundleId();
    }

    public void mergeBundleData(GeyserSession session, BundleCache.BundleData oldBundleData) {
        if (oldBundleData != null && this.bundleData != null) {
            this.bundleData.updateNetIds(session, oldBundleData);
        } else if (this.bundleData != null) {
            session.getBundleCache().markNewBundle(this.bundleData);
        }
    }

    public void add(int add) {
        this.amount += add;
    }

    public void sub(int sub) {
        this.amount -= sub;
    }

    public ItemStack getItemStack() {
        return this.getItemStack(this.amount);
    }

    public @Nullable ItemStack getItemStack(int newAmount) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.bundleData != null && !this.bundleData.freshFromServer()) {
            if (!this.bundleData.contents().isEmpty()) {
                this.getOrCreateComponents().put(DataComponentTypes.BUNDLE_CONTENTS, this.bundleData.toComponent());
            } else if (this.components != null) {
                this.components.getDataComponents().remove(DataComponentTypes.BUNDLE_CONTENTS);
            }
        }
        return this.isEmpty() ? null : new ItemStack(this.javaId, newAmount, this.components);
    }

    public ItemData getItemData(GeyserSession session) {
        if (this.isEmpty()) {
            return ItemData.AIR;
        }
        ItemData.Builder itemData = ItemTranslator.translateToBedrock(session, this.javaId, this.amount, this.components);
        itemData.netId(this.getNetId());
        itemData.usingNetId(true);
        return session.getBundleCache().checkForBundle(this, itemData);
    }

    public ItemMapping getMapping(GeyserSession session) {
        return session.getItemMappings().getMapping(this.javaId);
    }

    public SlotDisplay asSlotDisplay() {
        if (this.isEmpty()) {
            return EmptySlotDisplay.INSTANCE;
        }
        return new ItemStackSlotDisplay(this.getItemStack());
    }

    public int getMaxStackSize() {
        return this.getComponentElseGet((DataComponentType)DataComponentTypes.MAX_STACK_SIZE, () -> 1);
    }

    public int getMaxDamage() {
        return this.getComponentElseGet((DataComponentType)DataComponentTypes.MAX_DAMAGE, () -> 0);
    }

    public int getDamage() {
        int damage = Math.max(this.getComponentElseGet((DataComponentType)DataComponentTypes.DAMAGE, () -> 0), 0);
        return Math.min(damage, this.getMaxDamage());
    }

    public boolean nextDamageWillBreak() {
        return this.isDamageable() && this.getDamage() >= this.getMaxDamage() - 1;
    }

    public boolean isDamageable() {
        return this.getComponent((DataComponentType)DataComponentTypes.MAX_DAMAGE) != null && this.getComponent(DataComponentTypes.UNBREAKABLE) == null && this.getComponent((DataComponentType)DataComponentTypes.DAMAGE) != null;
    }

    public boolean isDamaged() {
        return this.isDamageable() && this.getDamage() > 0;
    }

    public Item asItem() {
        if (this.isEmpty()) {
            return Items.AIR;
        }
        if (this.item == null) {
            this.item = (Item)((List)Registries.JAVA_ITEMS.get()).get(this.javaId);
            return this.item;
        }
        return this.item;
    }

    public boolean isEmpty() {
        return this.amount <= 0 || this.javaId == Items.AIR_ID;
    }

    public GeyserItemStack copy() {
        return this.copy(this.amount);
    }

    public GeyserItemStack copy(int newAmount) {
        return this.isEmpty() ? EMPTY : new GeyserItemStack(this.javaId, newAmount, this.components == null ? null : this.components.clone(), this.netId, this.bundleData == null ? null : this.bundleData.copy());
    }

    @Generated
    public BundleCache.BundleData getBundleData() {
        return this.bundleData;
    }

    @Generated
    public void setAmount(int amount) {
        this.amount = amount;
    }

    @Generated
    public void setComponents(DataComponents components) {
        this.components = components;
    }

    @Generated
    public void setNetId(int netId) {
        this.netId = netId;
    }

    @Generated
    public void setBundleData(BundleCache.BundleData bundleData) {
        this.bundleData = bundleData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeyserItemStack)) {
            return false;
        }
        GeyserItemStack other = (GeyserItemStack)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getJavaId() != other.getJavaId()) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        if (this.getNetId() != other.getNetId()) {
            return false;
        }
        DataComponents this$components = this.getComponents();
        DataComponents other$components = other.getComponents();
        return !(this$components == null ? other$components != null : !this$components.equals(other$components));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GeyserItemStack;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getJavaId();
        result = result * 59 + this.getAmount();
        result = result * 59 + this.getNetId();
        DataComponents $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : $components.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GeyserItemStack(javaId=" + this.getJavaId() + ", amount=" + this.getAmount() + ", components=" + String.valueOf(this.getComponents()) + ", netId=" + this.getNetId() + ", bundleData=" + String.valueOf(this.getBundleData()) + ", item=" + String.valueOf(this.item) + ")";
    }
}

