/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.impl.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.api.entity.data.types.Hitbox;

public record HitboxImpl(Vector3f min, Vector3f max, Vector3f pivot) implements Hitbox
{
    public static List<Hitbox> fromMetaData(@Nullable NbtMap metaDataMap) {
        if (metaDataMap == null) {
            return List.of();
        }
        ArrayList<Hitbox> boxes = new ArrayList<Hitbox>();
        List hitboxes = metaDataMap.getList("Hitboxes", NbtType.COMPOUND);
        for (NbtMap hitbox : hitboxes) {
            boxes.add(new HitboxImpl(Vector3f.from((float)hitbox.getFloat("MinX"), (float)hitbox.getFloat("MinY"), (float)hitbox.getFloat("MinZ")), Vector3f.from((float)hitbox.getFloat("MaxX"), (float)hitbox.getFloat("MaxY"), (float)hitbox.getFloat("MaxZ")), Vector3f.from((float)hitbox.getFloat("PivotX"), (float)hitbox.getFloat("PivotY"), (float)hitbox.getFloat("PivotZ"))));
        }
        return boxes;
    }

    public NbtMap toNbtMap() {
        return NbtMap.builder().putFloat("MinX", this.min.getX()).putFloat("MinY", this.min.getY()).putFloat("MinZ", this.min.getZ()).putFloat("MaxX", this.max.getX()).putFloat("MaxY", this.max.getY()).putFloat("MaxZ", this.max.getZ()).putFloat("PivotX", this.pivot.getX()).putFloat("PivotY", this.pivot.getY()).putFloat("PivotZ", this.pivot.getZ()).build();
    }

    public static NbtMap toNbtMap(List<Hitbox> hitboxes) {
        ArrayList<NbtMap> list = new ArrayList<NbtMap>();
        for (Hitbox hitbox : hitboxes) {
            if (hitbox instanceof HitboxImpl) {
                HitboxImpl impl = (HitboxImpl)hitbox;
                list.add(impl.toNbtMap());
                continue;
            }
            throw new IllegalArgumentException("Unknown hitbox class implementation: " + hitbox.getClass().getSimpleName());
        }
        return NbtMap.builder().putList("Hitboxes", NbtType.COMPOUND, list).build();
    }

    public static class Builder
    implements Hitbox.Builder {
        Vector3f min;
        Vector3f max;
        Vector3f pivot;

        @Override
        public Hitbox.Builder min(@NonNull Vector3f min) {
            Objects.requireNonNull(min, "min");
            this.min = min;
            return this;
        }

        @Override
        public Hitbox.Builder max(@NonNull Vector3f max) {
            Objects.requireNonNull(max, "max");
            this.max = max;
            return this;
        }

        @Override
        public Hitbox.Builder pivot(@NonNull Vector3f pivot) {
            Objects.requireNonNull(pivot, "pivot");
            this.pivot = pivot;
            return this;
        }

        @Override
        public Hitbox build() {
            return new HitboxImpl(this.min == null ? Vector3f.ZERO : this.min, this.max == null ? Vector3f.ZERO : this.max, this.pivot == null ? Vector3f.ZERO : this.pivot);
        }
    }
}

