/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.vehicle;

import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.MoveEntityDeltaPacket;
import org.geysermc.erosion.util.BlockPositionIterator;
import org.geysermc.geyser.entity.type.BoatEntity;
import org.geysermc.geyser.entity.vehicle.VehicleComponent;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.Fluid;
import org.geysermc.geyser.level.block.type.BedBlock;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.Axis;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level.ServerboundMoveVehiclePacket;

public class BoatVehicleComponent
extends VehicleComponent<BoatEntity> {
    private Status status;
    private Status oldStatus;
    private double waterLevel;
    private float landFriction;
    private double lastYd;
    private float deltaRotation;

    public BoatVehicleComponent(BoatEntity vehicle, float stepHeight) {
        super(vehicle, stepHeight);
        this.gravity = 0.04;
    }

    @Override
    public void tickVehicle() {
        if (!((BoatEntity)this.vehicle).isClientControlled()) {
            return;
        }
        VehicleComponent.VehicleContext context = new VehicleComponent.VehicleContext(this);
        context.loadSurroundingBlocks();
        this.oldStatus = this.status;
        this.status = this.getStatus(context);
        this.floatBoat(context);
        Vector3f lastRotation = ((BoatEntity)this.vehicle).getBedrockRotation();
        this.controlBoat();
        Vector3f motion = ((BoatEntity)this.vehicle).getMotion();
        Vector3f movementMultiplier = this.getBlockMovementMultiplier(context);
        if (movementMultiplier != null) {
            motion = motion.mul(movementMultiplier);
        }
        Vector3d correctedMovement = ((BoatEntity)this.vehicle).getSession().getWorldBorder().correctMovement(this.boundingBox, motion.toDouble());
        correctedMovement = ((BoatEntity)this.vehicle).getSession().getCollisionManager().correctMovement(correctedMovement, this.boundingBox, ((BoatEntity)this.vehicle).isOnGround(), this.stepHeight, true, ((BoatEntity)this.vehicle).canWalkOnLava());
        Vector3d moveDiff = motion.toDouble().sub(correctedMovement);
        this.boundingBox.translate(correctedMovement);
        context.loadSurroundingBlocks();
        boolean verticalCollision = moveDiff.getY() != 0.0;
        ((BoatEntity)this.vehicle).setOnGround(verticalCollision && motion.getY() < 0.0f);
        boolean bounced = false;
        if (((BoatEntity)this.vehicle).isOnGround()) {
            Block landingBlock = this.getLandingBlock(context).block();
            if (landingBlock == Blocks.SLIME_BLOCK) {
                motion = Vector3f.from((float)motion.getX(), (float)(-motion.getY()), (float)motion.getZ());
                bounced = true;
                float absY = Math.abs(motion.getY());
                if (absY < 0.1f) {
                    float mul = 0.4f + absY * 0.2f;
                    motion = motion.mul(mul, 1.0f, mul);
                }
            } else if (landingBlock instanceof BedBlock) {
                motion = Vector3f.from((float)motion.getX(), (float)(-motion.getY() * 0.66f), (float)motion.getZ());
                bounced = true;
            }
        }
        motion = movementMultiplier != null ? Vector3f.ZERO : motion.mul(moveDiff.getX() == 0.0 ? 1.0f : 0.0f, !verticalCollision || bounced ? 1.0f : 0.0f, moveDiff.getZ() == 0.0 ? 1.0f : 0.0f);
        this.moveVehicle(context.centerPos(), lastRotation);
        ((BoatEntity)this.vehicle).setMotion(motion);
        this.applyBlockCollisionEffects(context);
        this.applyBlockCollisionEffects(context);
    }

    @Override
    protected void moveVehicle(Vector3d javaPos, Vector3f lastRotation) {
        Vector3f oldPosition = ((BoatEntity)this.vehicle).position();
        ((BoatEntity)this.vehicle).setPosition(javaPos.toFloat());
        MoveEntityDeltaPacket moveEntityDeltaPacket = new MoveEntityDeltaPacket();
        moveEntityDeltaPacket.setRuntimeEntityId(((BoatEntity)this.vehicle).geyserId());
        if (((BoatEntity)this.vehicle).isOnGround()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.ON_GROUND);
        }
        if (((BoatEntity)this.vehicle).position().getX() != oldPosition.getX()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_X);
            moveEntityDeltaPacket.setX(((BoatEntity)this.vehicle).bedrockPosition().getX());
        }
        if (((BoatEntity)this.vehicle).position().getY() != oldPosition.getY()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_Y);
            moveEntityDeltaPacket.setY(((BoatEntity)this.vehicle).bedrockPosition().getY());
        }
        if (((BoatEntity)this.vehicle).position().getZ() != oldPosition.getZ()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_Z);
            moveEntityDeltaPacket.setZ(((BoatEntity)this.vehicle).bedrockPosition().getZ());
        }
        if (((BoatEntity)this.vehicle).getPitch() != lastRotation.getX()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_PITCH);
            moveEntityDeltaPacket.setPitch(((BoatEntity)this.vehicle).getPitch());
        }
        if (((BoatEntity)this.vehicle).getYaw() != lastRotation.getY()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_YAW);
            moveEntityDeltaPacket.setYaw(((BoatEntity)this.vehicle).getYaw());
        }
        if (((BoatEntity)this.vehicle).getHeadYaw() != lastRotation.getZ()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_HEAD_YAW);
            moveEntityDeltaPacket.setHeadYaw(((BoatEntity)this.vehicle).getHeadYaw());
        }
        if (!moveEntityDeltaPacket.getFlags().isEmpty()) {
            ((BoatEntity)this.vehicle).getSession().sendUpstreamPacketImmediately((BedrockPacket)moveEntityDeltaPacket);
        }
        ServerboundMoveVehiclePacket moveVehiclePacket = new ServerboundMoveVehiclePacket(javaPos, ((BoatEntity)this.vehicle).getYaw() - 90.0f, ((BoatEntity)this.vehicle).getPitch(), ((BoatEntity)this.vehicle).isOnGround());
        ((BoatEntity)this.vehicle).getSession().sendDownstreamPacket((Packet)moveVehiclePacket);
    }

    private void controlBoat() {
        boolean right;
        float acceleration = 0.0f;
        Vector2f input = ((BoatEntity)this.vehicle).getSession().getPlayerEntity().getVehicleInput();
        boolean up = (double)input.getY() > 0.35;
        boolean down = (double)input.getY() < -0.35;
        boolean left = (double)input.getX() > 0.35;
        boolean bl = right = (double)input.getX() < -0.35;
        if (left) {
            this.deltaRotation -= 1.0f;
        }
        if (right) {
            this.deltaRotation += 1.0f;
        }
        if (right != left && !up && !down) {
            acceleration += 0.005f;
        }
        ((BoatEntity)this.vehicle).setYaw(((BoatEntity)this.vehicle).getYaw() + this.deltaRotation);
        ((BoatEntity)this.vehicle).setHeadYaw(((BoatEntity)this.vehicle).getYaw());
        if (up) {
            acceleration += 0.04f;
        }
        if (down) {
            acceleration -= 0.005f;
        }
        float yaw = ((BoatEntity)this.vehicle).getYaw() - 90.0f;
        Vector3f motion = Vector3f.from((float)(TrigMath.sin((double)(-yaw * ((float)Math.PI / 180))) * acceleration), (float)0.0f, (float)(TrigMath.cos((double)(yaw * ((float)Math.PI / 180))) * acceleration));
        ((BoatEntity)this.vehicle).setMotion(((BoatEntity)this.vehicle).getMotion().add(motion));
        ((BoatEntity)this.vehicle).getSession().setSteeringLeft(right && !left || up);
        ((BoatEntity)this.vehicle).getSession().setSteeringRight(left && !right || up);
    }

    private void floatBoat(VehicleComponent.VehicleContext context) {
        double gravity = -this.getGravity();
        double buoyancy = 0.0;
        float frictionMutiplier = 0.05f;
        if (this.oldStatus == Status.IN_AIR && this.status != Status.IN_AIR && this.status != Status.ON_LAND) {
            this.waterLevel = this.getBoundingBox().getMax(Axis.Y);
            double targetY = (double)(this.getWaterLevelAbove(context) - ((BoatEntity)this.vehicle).getBoundingBoxHeight()) + 0.101;
            BoundingBox box = this.boundingBox.clone();
            box.translate(0.0, targetY - this.getBoundingBox().getMin(Axis.Y), 0.0);
            boolean empty = true;
            BlockPositionIterator iter = ((BoatEntity)this.vehicle).getSession().getCollisionManager().collidableBlocksIterator(box);
            while (iter.hasNext()) {
                BlockCollision collision = BlockUtils.getCollision(context.getBlockId(iter.getX(), iter.getY(), iter.getZ()));
                if (collision != null && collision.checkIntersection(Vector3i.from((int)iter.getX(), (int)iter.getY(), (int)iter.getZ()), box)) {
                    empty = false;
                    break;
                }
                iter.next();
            }
            if (empty) {
                ((BoatEntity)this.vehicle).setMotion(((BoatEntity)this.vehicle).getMotion().mul(1.0f, 0.0f, 1.0f));
                this.boundingBox.setMiddleY(targetY + this.boundingBox.getSizeY() / 2.0);
                this.lastYd = 0.0;
            }
            this.status = Status.IN_WATER;
        } else {
            if (this.status == Status.IN_WATER) {
                buoyancy = (this.waterLevel - this.getBoundingBox().getMin(Axis.Y)) / (double)((BoatEntity)this.vehicle).getBoundingBoxHeight();
                frictionMutiplier = 0.9f;
            } else if (this.status == Status.UNDER_FLOWING_WATER) {
                gravity = -7.0E-4;
                frictionMutiplier = 0.9f;
            } else if (this.status == Status.UNDER_WATER) {
                buoyancy = 0.01f;
                frictionMutiplier = 0.45f;
            } else if (this.status == Status.IN_AIR) {
                frictionMutiplier = 0.9f;
            } else if (this.status == Status.ON_LAND) {
                frictionMutiplier = this.landFriction;
                this.landFriction /= 2.0f;
            }
            ((BoatEntity)this.vehicle).setMotion(((BoatEntity)this.vehicle).getMotion().mul(frictionMutiplier, 1.0f, frictionMutiplier).up((float)gravity));
            this.deltaRotation *= frictionMutiplier;
            if (buoyancy > 0.0) {
                Vector3f motion = ((BoatEntity)this.vehicle).getMotion();
                ((BoatEntity)this.vehicle).setMotion(Vector3f.from((float)motion.getX(), (float)((float)((double)motion.getY() + buoyancy * (this.gravity / 0.65)) * 0.75f), (float)motion.getZ()));
            }
        }
    }

    private float getWaterLevelAbove(VehicleComponent.VehicleContext context) {
        BoundingBox aabb = this.getBoundingBox();
        int minX = GenericMath.floor((double)aabb.getMin(Axis.X));
        int maxX = GenericMath.ceil((double)aabb.getMax(Axis.X));
        int minY = GenericMath.floor((double)aabb.getMax(Axis.Y));
        int maxY = GenericMath.ceil((double)(aabb.getMax(Axis.Y) - this.lastYd));
        int minZ = GenericMath.floor((double)aabb.getMin(Axis.Z));
        int maxZ = GenericMath.ceil((double)aabb.getMax(Axis.Z));
        for (int y = minY; y < maxY; ++y) {
            float blockHeight = 0.0f;
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    float fluidHeight = this.getLogicalFluidHeight(Fluid.WATER, context.getBlockId(x, y, z));
                    if (!(fluidHeight > 0.0f)) continue;
                    blockHeight = Math.max(blockHeight, fluidHeight);
                }
            }
            if (!(blockHeight < 1.0f)) continue;
            return (float)y + blockHeight;
        }
        return maxY + 1;
    }

    private float getGroundFriction(VehicleComponent.VehicleContext context) {
        BoundingBox boatShape = this.getBoundingBox().clone();
        boatShape.setMiddleY(boatShape.getMin(Axis.Y) - 5.0E-4);
        boatShape.setSizeY(0.001);
        if (boatShape.isEmpty()) {
            return Float.NaN;
        }
        int x0 = GenericMath.floor((double)boatShape.getMin(Axis.X)) - 1;
        int x1 = GenericMath.ceil((double)boatShape.getMax(Axis.X)) + 1;
        int y0 = GenericMath.floor((double)boatShape.getMin(Axis.Y)) - 1;
        int y1 = GenericMath.ceil((double)boatShape.getMax(Axis.Y)) + 1;
        int z0 = GenericMath.floor((double)boatShape.getMin(Axis.Z)) - 1;
        int z1 = GenericMath.ceil((double)boatShape.getMax(Axis.Z)) + 1;
        float friction = 0.0f;
        int count = 0;
        for (int x = x0; x < x1; ++x) {
            for (int z = z0; z < z1; ++z) {
                int edges = (x == x0 || x == x1 - 1 ? 1 : 0) + (z == z0 || z == z1 - 1 ? 1 : 0);
                if (edges == 2) continue;
                for (int y = y0; y < y1; ++y) {
                    BlockCollision collision;
                    BlockState state;
                    if (edges > 0 && (y == y0 || y == y1 - 1) || (state = context.getBlock(x, y, z)).is(Blocks.LILY_PAD) || (collision = BlockUtils.getCollision(state.javaId())) == null || collision.getBoundingBoxes().length == 0 || !collision.checkIntersection(Vector3i.from((int)x, (int)y, (int)z), boatShape)) continue;
                    friction += BlockStateValues.getSlipperiness(state);
                    ++count;
                }
            }
        }
        return friction / (float)count;
    }

    private Status isUnderwater(VehicleComponent.VehicleContext context) {
        BoundingBox boatShape = this.getBoundingBox().clone();
        double maxY = boatShape.getMax(Axis.Y) + 0.001;
        int x0 = GenericMath.floor((double)boatShape.getMin(Axis.X));
        int x1 = GenericMath.ceil((double)boatShape.getMax(Axis.X));
        int y0 = GenericMath.floor((double)boatShape.getMax(Axis.Y));
        int y1 = GenericMath.ceil((double)maxY);
        int z0 = GenericMath.floor((double)boatShape.getMin(Axis.Z));
        int z1 = GenericMath.ceil((double)boatShape.getMax(Axis.Z));
        boolean underWater = false;
        for (int x = x0; x < x1; ++x) {
            for (int y = y0; y < y1; ++y) {
                for (int z = z0; z < z1; ++z) {
                    float fluidHeight = this.getLogicalFluidHeight(Fluid.WATER, context.getBlockId(x, y, z));
                    if (fluidHeight <= 0.0f || maxY > (double)((float)y + fluidHeight)) continue;
                    if (fluidHeight == 1.0f) {
                        underWater = true;
                        continue;
                    }
                    return Status.UNDER_FLOWING_WATER;
                }
            }
        }
        return underWater ? Status.UNDER_WATER : null;
    }

    private boolean checkInWater(VehicleComponent.VehicleContext context) {
        this.waterLevel = Double.MIN_VALUE;
        BoundingBox boatShape = this.getBoundingBox();
        int minX = GenericMath.floor((double)boatShape.getMin(Axis.X));
        int maxX = GenericMath.ceil((double)boatShape.getMax(Axis.X));
        int minY = GenericMath.floor((double)boatShape.getMin(Axis.Y));
        int maxY = GenericMath.ceil((double)(boatShape.getMin(Axis.Y) + 0.001));
        int minZ = GenericMath.floor((double)boatShape.getMin(Axis.Z));
        int maxZ = GenericMath.ceil((double)boatShape.getMax(Axis.Z));
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    float fluidHeight = this.getLogicalFluidHeight(Fluid.WATER, context.getBlockId(x, y, z));
                    if (fluidHeight <= 0.0f) continue;
                    float height = (float)y + fluidHeight;
                    this.waterLevel = Math.max((double)height, this.waterLevel);
                    if (!(boatShape.getMin(Axis.Y) < (double)height)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Status getStatus(VehicleComponent.VehicleContext context) {
        Status waterStatus = this.isUnderwater(context);
        if (waterStatus != null) {
            this.waterLevel = this.getBoundingBox().getMax(Axis.Y);
            return waterStatus;
        }
        if (this.checkInWater(context)) {
            return Status.IN_WATER;
        }
        float friction = this.getGroundFriction(context);
        if (friction > 0.0f) {
            this.landFriction = friction;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

