/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.MobEquipmentPacket;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.monster.BasePiglinEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;

public class PiglinEntity
extends BasePiglinEntity {
    public PiglinEntity(EntitySpawnContext context) {
        super(context);
    }

    public void setBaby(BooleanEntityMetadata entityMetadata) {
        boolean isBaby = entityMetadata.getPrimitiveValue();
        this.setScale(isBaby ? 0.55f : 1.0f);
        this.setFlag(EntityFlag.BABY, isBaby);
        this.updateMountOffset();
    }

    public void setChargingCrossbow(BooleanEntityMetadata entityMetadata) {
        boolean charging = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.CHARGING, charging);
        this.dirtyMetadata.put(EntityDataTypes.CHARGE_AMOUNT, charging ? (byte)64 : 0);
    }

    public void setDancing(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.DANCING, entityMetadata.getPrimitiveValue());
    }

    @Override
    public void setHand(GeyserItemStack stack) {
        boolean toCrossbow;
        boolean bl = toCrossbow = stack != null && stack.is(Items.CROSSBOW);
        if (toCrossbow ^ this.getMainHandItem().is(Items.CROSSBOW)) {
            this.dirtyMetadata.put(EntityDataTypes.BLOCK, this.session.getBlockMappings().getDefinition(toCrossbow ? 0 : 1));
            this.dirtyMetadata.put(EntityDataTypes.CHARGE_AMOUNT, (byte)0);
            this.setFlag(EntityFlag.CHARGED, false);
            this.setFlag(EntityFlag.USING_ITEM, false);
            this.updateBedrockMetadata();
            if (!this.getMainHandItem().isEmpty()) {
                MobEquipmentPacket mobEquipmentPacket = new MobEquipmentPacket();
                mobEquipmentPacket.setRuntimeEntityId(this.geyserId);
                mobEquipmentPacket.setContainerId(0);
                mobEquipmentPacket.setInventorySlot(0);
                mobEquipmentPacket.setHotbarSlot(-1);
                mobEquipmentPacket.setItem(ItemData.AIR);
                this.session.sendUpstreamPacket((BedrockPacket)mobEquipmentPacket);
            }
        }
        super.setHand(stack);
    }

    @Override
    public void updateMainHand() {
        super.updateMainHand();
        if (this.getMainHandItem().is(Items.CROSSBOW)) {
            if (this.getMainHandItem().getComponent(DataComponentTypes.CHARGED_PROJECTILES) != null) {
                this.dirtyMetadata.put(EntityDataTypes.CHARGE_AMOUNT, (byte)127);
                this.setFlag(EntityFlag.CHARGING, false);
                this.setFlag(EntityFlag.CHARGED, true);
                this.setFlag(EntityFlag.USING_ITEM, true);
            } else if (this.getFlag(EntityFlag.CHARGED)) {
                this.dirtyMetadata.put(EntityDataTypes.CHARGE_AMOUNT, (byte)0);
                this.setFlag(EntityFlag.CHARGED, false);
                this.setFlag(EntityFlag.USING_ITEM, false);
            }
        }
        this.updateBedrockMetadata();
    }

    @Override
    public void updateOffHand() {
        this.setFlag(EntityFlag.ADMIRING, this.getOffHandItem().is(this.session, ItemTag.PIGLIN_LOVED));
        super.updateBedrockMetadata();
        super.updateOffHand();
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        InteractiveTag tag = super.testMobInteraction(hand, itemInHand);
        if (tag != InteractiveTag.NONE) {
            return tag;
        }
        return this.canGiveGoldTo(itemInHand) ? InteractiveTag.BARTER : InteractiveTag.NONE;
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        InteractionResult superResult = super.mobInteract(hand, itemInHand);
        if (superResult.consumesAction()) {
            return superResult;
        }
        return this.canGiveGoldTo(itemInHand) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    private boolean canGiveGoldTo(@NonNull GeyserItemStack itemInHand) {
        return !this.getFlag(EntityFlag.BABY) && itemInHand.is(Items.GOLD_INGOT) && !this.getFlag(EntityFlag.ADMIRING);
    }
}

