/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import java.util.Optional;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.LevelEventType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventGenericPacket;
import org.geysermc.geyser.entity.properties.type.EnumProperty;
import org.geysermc.geyser.entity.properties.type.IntProperty;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.monster.MonsterEntity;
import org.geysermc.geyser.impl.IdentifierImpl;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.MetadataType;

public class CreakingEntity
extends MonsterEntity {
    public static final EnumProperty<CreakingState> STATE_PROPERTY = new EnumProperty<CreakingState>(IdentifierImpl.of("creaking_state"), CreakingState.class, CreakingState.NEUTRAL);
    public static final IntProperty SWAYING_TICKS_PROPERTY = new IntProperty(IdentifierImpl.of("creaking_swaying_ticks"), 6, 0, 0);
    private Vector3i homePosition;

    public CreakingEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.setFlag(EntityFlag.FIRE_IMMUNE, true);
    }

    public void setCanMove(EntityMetadata<Boolean, ? extends MetadataType<Boolean>> booleanEntityMetadata) {
        this.setFlag(EntityFlag.BODY_ROTATION_BLOCKED, (Boolean)booleanEntityMetadata.getValue() == false);
        STATE_PROPERTY.apply(this.propertyManager, (Boolean)booleanEntityMetadata.getValue() != false ? CreakingState.HOSTILE_UNOBSERVED : CreakingState.HOSTILE_OBSERVED);
        this.updateBedrockEntityProperties();
    }

    public void setActive(EntityMetadata<Boolean, ? extends MetadataType<Boolean>> booleanEntityMetadata) {
        if (!((Boolean)booleanEntityMetadata.getValue()).booleanValue()) {
            STATE_PROPERTY.apply(this.propertyManager, CreakingState.NEUTRAL);
        }
    }

    public void setIsTearingDown(EntityMetadata<Boolean, ? extends MetadataType<Boolean>> booleanEntityMetadata) {
        if (((Boolean)booleanEntityMetadata.getValue()).booleanValue()) {
            STATE_PROPERTY.apply(this.propertyManager, CreakingState.CRUMBLING);
            this.updateBedrockEntityProperties();
        }
    }

    public void setHomePos(EntityMetadata<Optional<Vector3i>, ? extends MetadataType<Optional<Vector3i>>> optionalEntityMetadata) {
        this.homePosition = ((Optional)optionalEntityMetadata.getValue()).isPresent() ? (Vector3i)((Optional)optionalEntityMetadata.getValue()).get() : null;
    }

    public void createParticleBeam() {
        if (this.homePosition != null) {
            LevelEventGenericPacket levelEventGenericPacket = new LevelEventGenericPacket();
            levelEventGenericPacket.setType((LevelEventType)LevelEvent.PARTICLE_CREAKING_HEART_TRIAL);
            levelEventGenericPacket.setTag((Object)NbtMap.builder().putInt("CreakingAmount", 20).putFloat("CreakingX", this.bedrockPosition().getX()).putFloat("CreakingY", this.bedrockPosition().getY()).putFloat("CreakingZ", this.bedrockPosition().getZ()).putInt("HeartAmount", 20).putFloat("HeartX", (float)this.homePosition.getX()).putFloat("HeartY", (float)this.homePosition.getY()).putFloat("HeartZ", (float)this.homePosition.getZ()).build());
            this.session.sendUpstreamPacket((BedrockPacket)levelEventGenericPacket);
        }
    }

    public static enum CreakingState {
        NEUTRAL,
        HOSTILE_OBSERVED,
        HOSTILE_UNOBSERVED,
        TWITCHING,
        CRUMBLING;

    }
}

