/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.EnumSet;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.ThrowableItemEntity;
import org.geysermc.geyser.inventory.item.Potion;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.BuiltinEntityType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.PotionContents;

public class ThrownPotionEntity
extends ThrowableItemEntity {
    private static final EnumSet<Potion> NON_ENCHANTED_POTIONS = EnumSet.of(Potion.WATER, Potion.MUNDANE, Potion.THICK, Potion.AWKWARD);

    public ThrownPotionEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    public void setItem(EntityMetadata<ItemStack, ?> entityMetadata) {
        ItemStack itemStack = (ItemStack)entityMetadata.getValue();
        if (itemStack == null) {
            this.dirtyMetadata.put(EntityDataTypes.AUX_VALUE_DATA, (short)0);
            this.setFlag(EntityFlag.ENCHANTED, false);
            this.setFlag(EntityFlag.LINGERING, false);
        } else {
            DataComponents components = itemStack.getDataComponentsPatch();
            if (components != null) {
                PotionContents potionContents = (PotionContents)components.get(DataComponentTypes.POTION_CONTENTS);
                if (potionContents != null) {
                    Potion potion = Potion.getByJavaId(potionContents.getPotionId());
                    if (potion != null) {
                        this.dirtyMetadata.put(EntityDataTypes.AUX_VALUE_DATA, potion.getBedrockId());
                        this.setFlag(EntityFlag.ENCHANTED, !NON_ENCHANTED_POTIONS.contains((Object)potion));
                    } else {
                        this.dirtyMetadata.put(EntityDataTypes.AUX_VALUE_DATA, (short)0);
                        GeyserImpl.getInstance().getLogger().debug("Unknown java potion: " + potionContents.getPotionId());
                    }
                }
                boolean isLingering = this.javaTypeDefinition.type().is((EntityType)BuiltinEntityType.LINGERING_POTION);
                this.setFlag(EntityFlag.LINGERING, isLingering);
            }
        }
    }
}

