/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.LevelEventType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.MoveEntityDeltaPacket;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.BuiltinEntityType;

public class ThrowableEntity
extends Entity
implements Tickable {
    protected Vector3f lastJavaPosition = this.position();

    public ThrowableEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    public void tick() {
        if (this.removedInVoid()) {
            return;
        }
        this.moveAbsoluteImmediate(this.position().add(this.motion), this.getYaw(), this.getPitch(), this.getHeadYaw(), this.isOnGround(), false);
        float drag = this.getDrag();
        float gravity = this.getGravity();
        this.motion = this.motion.mul(drag).down(gravity);
    }

    protected void moveAbsoluteImmediate(Vector3f javaPosition, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        Vector3f oldPosition = this.position();
        this.setPosition(javaPosition);
        MoveEntityDeltaPacket moveEntityDeltaPacket = new MoveEntityDeltaPacket();
        moveEntityDeltaPacket.setRuntimeEntityId(this.geyserId);
        if (isOnGround) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.ON_GROUND);
        }
        this.setOnGround(isOnGround);
        if (teleported) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.TELEPORTING);
        }
        if (this.position().getX() != oldPosition.getX()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_X);
            moveEntityDeltaPacket.setX(this.bedrockPosition().getX());
        }
        if (this.position().getY() != oldPosition.getY()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_Y);
            moveEntityDeltaPacket.setY(this.bedrockPosition().getY());
        }
        if (this.position().getZ() != oldPosition.getZ()) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_Z);
            moveEntityDeltaPacket.setZ(this.bedrockPosition().getZ());
        }
        if (this.getYaw() != yaw) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_YAW);
            moveEntityDeltaPacket.setYaw(yaw);
            this.setYaw(yaw);
        }
        if (this.getPitch() != pitch) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_PITCH);
            moveEntityDeltaPacket.setPitch(pitch);
            this.setPitch(pitch);
        }
        if (this.getHeadYaw() != headYaw) {
            moveEntityDeltaPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_HEAD_YAW);
            moveEntityDeltaPacket.setHeadYaw(headYaw);
            this.setHeadYaw(headYaw);
        }
        if (!moveEntityDeltaPacket.getFlags().isEmpty()) {
            this.session.getQueuedImmediatelyPackets().add((BedrockPacket)moveEntityDeltaPacket);
        }
    }

    protected float getGravity() {
        if (this.getFlag(EntityFlag.HAS_GRAVITY)) {
            if (this.javaTypeDefinition.is(BuiltinEntityType.LINGERING_POTION) || this.javaTypeDefinition.is(BuiltinEntityType.SPLASH_POTION)) {
                return 0.05f;
            }
            if (this.javaTypeDefinition.is(BuiltinEntityType.EXPERIENCE_BOTTLE)) {
                return 0.07f;
            }
            if (this.javaTypeDefinition.is(BuiltinEntityType.FIREBALL) || this.javaTypeDefinition.is(BuiltinEntityType.SHULKER_BULLET)) {
                return 0.0f;
            }
            if (this.javaTypeDefinition.is(BuiltinEntityType.SNOWBALL) || this.javaTypeDefinition.is(BuiltinEntityType.EGG) || this.javaTypeDefinition.is(BuiltinEntityType.ENDER_PEARL)) {
                return 0.03f;
            }
            if (this.javaTypeDefinition.is(BuiltinEntityType.LLAMA_SPIT)) {
                return 0.06f;
            }
        }
        return 0.0f;
    }

    protected float getDrag() {
        if (this.isInWater()) {
            return 0.8f;
        }
        if (this.javaTypeDefinition.is(BuiltinEntityType.LINGERING_POTION) || this.javaTypeDefinition.is(BuiltinEntityType.SPLASH_POTION) || this.javaTypeDefinition.is(BuiltinEntityType.EXPERIENCE_BOTTLE) || this.javaTypeDefinition.is(BuiltinEntityType.SNOWBALL) || this.javaTypeDefinition.is(BuiltinEntityType.EGG) || this.javaTypeDefinition.is(BuiltinEntityType.ENDER_PEARL) || this.javaTypeDefinition.is(BuiltinEntityType.LLAMA_SPIT)) {
            return 0.99f;
        }
        if (this.javaTypeDefinition.is(BuiltinEntityType.FIREBALL) || this.javaTypeDefinition.is(BuiltinEntityType.SMALL_FIREBALL) || this.javaTypeDefinition.is(BuiltinEntityType.DRAGON_FIREBALL)) {
            return 0.95f;
        }
        if (this.javaTypeDefinition.is(BuiltinEntityType.SHULKER_BULLET)) {
            return 1.0f;
        }
        return 1.0f;
    }

    protected boolean isInWater() {
        int block = this.session.getGeyser().getWorldManager().getBlockAt(this.session, this.position().toInt());
        return BlockStateValues.getWaterLevel(block) != -1;
    }

    @Override
    public void despawnEntity() {
        if (this.javaTypeDefinition.is(BuiltinEntityType.ENDER_PEARL)) {
            LevelEventPacket particlePacket = new LevelEventPacket();
            particlePacket.setType((LevelEventType)LevelEvent.PARTICLE_TELEPORT);
            particlePacket.setPosition(this.bedrockPosition());
            this.session.sendUpstreamPacket((BedrockPacket)particlePacket);
        }
        super.despawnEntity();
    }

    @Override
    public void moveRelativeRaw(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        this.moveAbsoluteImmediate(this.lastJavaPosition.add(relX, relY, relZ), yaw, pitch, headYaw, isOnGround, false);
        this.lastJavaPosition = this.position();
    }

    @Override
    public void moveAbsoluteRaw(Vector3f javaPosition, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        this.moveAbsoluteImmediate(javaPosition, yaw, pitch, headYaw, isOnGround, teleported);
        this.lastJavaPosition = javaPosition;
    }

    public boolean removedInVoid() {
        if (this.position().getY() < (float)(this.session.getDimensionType().minY() - 64)) {
            this.session.getEntityCache().removeEntity(this);
            return true;
        }
        return false;
    }
}

