/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import lombok.Generated;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BlockEntityDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.HangingEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.BuiltinEntityType;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class ItemFrameEntity
extends HangingEntity {
    private final Vector3i bedrockPosition;
    private BlockDefinition blockDefinition = this.buildBlockDefinition(Direction.SOUTH);
    private float rotation = 0.0f;
    private NbtMap cachedTag;
    private ItemStack heldItem = null;
    private boolean changed = true;

    public ItemFrameEntity(EntitySpawnContext context) {
        super(context);
        this.bedrockPosition = this.position().floor().toInt();
        this.session.getItemFrameCache().put(this.bedrockPosition, this);
    }

    @Override
    protected void initializeMetadata() {
    }

    @Override
    public void spawnEntity() {
        this.updateBlock(true);
        this.session.getGeyser().getLogger().debug("Spawned item frame at location " + String.valueOf(this.bedrockPosition) + " with java id " + this.entityId);
        this.valid = true;
    }

    @Override
    public void setDirection(Direction direction) {
        this.blockDefinition = this.buildBlockDefinition(direction);
        this.changed = true;
    }

    public void setItemInFrame(EntityMetadata<ItemStack, ?> entityMetadata) {
        if (entityMetadata.getValue() != null) {
            this.heldItem = (ItemStack)entityMetadata.getValue();
            ItemData itemData = ItemTranslator.translateToBedrock(this.session, this.heldItem);
            String customIdentifier = (String)this.session.getItemMappings().getCustomIdMappings().get(itemData.getDefinition().getRuntimeId());
            NbtMapBuilder builder = NbtMap.builder();
            builder.putByte("Count", (byte)itemData.getCount());
            NbtMap itemDataTag = itemData.getTag();
            if (itemDataTag != null) {
                String customName = ItemTranslator.getCustomName(this.session, this.heldItem.getDataComponentsPatch(), this.session.getItemMappings().getMapping(this.heldItem), 'f', true, false);
                if (customName == null) {
                    NbtMapBuilder copy = itemDataTag.toBuilder();
                    copy.remove((Object)"display");
                    itemDataTag = copy.build();
                }
                builder.put("tag", (Object)itemDataTag);
            }
            builder.putShort("Damage", (short)itemData.getDamage());
            builder.putString("Name", customIdentifier != null ? customIdentifier : this.session.getItemMappings().getMapping((ItemStack)entityMetadata.getValue()).getBedrockIdentifier());
            NbtMapBuilder tag = this.getDefaultTag().toBuilder();
            tag.put("Item", (Object)builder.build());
            tag.putFloat("ItemDropChance", 1.0f);
            tag.putFloat("ItemRotation", this.rotation);
            this.cachedTag = tag.build();
            this.changed = true;
        } else if (this.cachedTag != null) {
            this.cachedTag = this.getDefaultTag();
            this.changed = true;
        }
    }

    public void setItemRotation(IntEntityMetadata entityMetadata) {
        this.rotation = entityMetadata.getPrimitiveValue() * 45;
        if (this.cachedTag == null) {
            return;
        }
        NbtMapBuilder builder = this.cachedTag.toBuilder();
        builder.putFloat("ItemRotation", this.rotation);
        this.cachedTag = builder.build();
        this.changed = true;
    }

    @Override
    public void despawnEntity() {
        UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
        updateBlockPacket.setDataLayer(0);
        updateBlockPacket.setBlockPosition(this.bedrockPosition);
        updateBlockPacket.setDefinition((BlockDefinition)this.session.getBlockMappings().getBedrockAir());
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.PRIORITY);
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NEIGHBORS);
        this.session.sendUpstreamPacket((BedrockPacket)updateBlockPacket);
        this.session.getItemFrameCache().remove(this.bedrockPosition, this);
        this.valid = false;
    }

    private NbtMap getDefaultTag() {
        NbtMapBuilder builder = NbtMap.builder();
        builder.putInt("x", this.bedrockPosition.getX());
        builder.putInt("y", this.bedrockPosition.getY());
        builder.putInt("z", this.bedrockPosition.getZ());
        builder.putByte("isMovable", (byte)1);
        builder.putString("id", this.javaTypeDefinition.is(BuiltinEntityType.GLOW_ITEM_FRAME) ? "GlowItemFrame" : "ItemFrame");
        return builder.build();
    }

    @Override
    public void updateBedrockMetadata() {
        this.updateBlock(false);
    }

    public void updateBlock(boolean force) {
        if (!this.changed && !force) {
            return;
        }
        UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
        updateBlockPacket.setDataLayer(0);
        updateBlockPacket.setBlockPosition(this.bedrockPosition);
        updateBlockPacket.setDefinition(this.blockDefinition);
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.PRIORITY);
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NEIGHBORS);
        this.session.sendUpstreamPacket((BedrockPacket)updateBlockPacket);
        BlockEntityDataPacket blockEntityDataPacket = new BlockEntityDataPacket();
        blockEntityDataPacket.setBlockPosition(this.bedrockPosition);
        if (this.cachedTag != null) {
            blockEntityDataPacket.setData(this.cachedTag);
        } else {
            blockEntityDataPacket.setData(this.getDefaultTag());
        }
        this.session.sendUpstreamPacket((BedrockPacket)blockEntityDataPacket);
        this.changed = false;
    }

    @Override
    public InteractionResult interact(Hand hand) {
        return InventoryUtils.isEmpty(this.heldItem) && this.session.getPlayerInventory().getItemInHand(hand).isEmpty() ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    private BlockDefinition buildBlockDefinition(Direction direction) {
        NbtMapBuilder blockBuilder = NbtMap.builder().putString("name", this.javaTypeDefinition.is(BuiltinEntityType.GLOW_ITEM_FRAME) ? "minecraft:glow_frame" : "minecraft:frame");
        NbtMapBuilder statesBuilder = NbtMap.builder().putInt("facing_direction", direction.ordinal()).putByte("item_frame_map_bit", (byte)0).putByte("item_frame_photo_bit", (byte)0);
        blockBuilder.put("states", (Object)statesBuilder.build());
        return this.session.getBlockMappings().getItemFrame(blockBuilder.build());
    }

    public static ItemFrameEntity getItemFrameEntity(GeyserSession session, Vector3i position) {
        return session.getItemFrameCache().get(position);
    }

    @Generated
    public ItemStack getHeldItem() {
        return this.heldItem;
    }
}

