/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.concurrent.ThreadLocalRandom;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlaySoundPacket;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.Tickable;

public class EvokerFangsEntity
extends Entity
implements Tickable {
    private int limitedLife = 22;
    private boolean attackStarted = false;

    public EvokerFangsEntity(EntitySpawnContext context) {
        super(context);
        this.dirtyMetadata.put(EntityDataTypes.DATA_LIFETIME_TICKS, this.limitedLife);
    }

    @Override
    public void tick() {
        if (this.attackStarted && --this.limitedLife > 0 && this.limitedLife % 2 == 0) {
            this.dirtyMetadata.put(EntityDataTypes.DATA_LIFETIME_TICKS, this.limitedLife);
            this.updateBedrockMetadata();
        }
    }

    public void setAttackStarted() {
        this.attackStarted = true;
        if (!this.silent) {
            PlaySoundPacket packet = new PlaySoundPacket();
            packet.setPosition(this.bedrockPosition());
            packet.setSound("mob.evocation_fangs.attack");
            packet.setVolume(1.0f);
            packet.setPitch(ThreadLocalRandom.current().nextFloat() * 0.2f + 0.85f);
            this.session.sendUpstreamPacket((BedrockPacket)packet);
        }
    }
}

