/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.entity.custom.CustomJavaEntityType;
import org.geysermc.geyser.api.entity.definition.GeyserEntityDefinition;
import org.geysermc.geyser.api.entity.definition.JavaEntityType;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.entity.BedrockEntityDefinition;
import org.geysermc.geyser.entity.EntityTypeDefinition;
import org.geysermc.geyser.impl.IdentifierImpl;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.BuiltinEntityType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;

public record GeyserEntityType(Identifier identifier, int javaId) implements JavaEntityType,
CustomJavaEntityType
{
    private static final Identifier UNREGISTERED = IdentifierImpl.of("geyser_custom", "unregistered_sadface");
    private static final Map<BuiltinEntityType, GeyserEntityType> VANILLA = new EnumMap<BuiltinEntityType, GeyserEntityType>(BuiltinEntityType.class);
    private static final Int2ObjectMap<GeyserEntityType> CUSTOM = new Int2ObjectOpenHashMap();
    private static final Object2ObjectMap<Identifier, GeyserEntityType> CUSTOM_BY_IDENTIFIER = new Object2ObjectOpenHashMap();

    private GeyserEntityType(BuiltinEntityType builtin) {
        this(IdentifierImpl.of(builtin.name().toLowerCase(Locale.ROOT)), builtin.id());
    }

    private GeyserEntityType(int javaId) {
        this(UNREGISTERED, javaId);
    }

    public boolean isUnregistered() {
        return this.identifier.equals(UNREGISTERED);
    }

    @Override
    public boolean vanilla() {
        return VANILLA.containsValue(this);
    }

    @Override
    public float width() {
        EntityTypeDefinition definition = (EntityTypeDefinition)Registries.JAVA_ENTITY_TYPES.get(this);
        if (definition == null) {
            throw new IllegalStateException("No entity definition registered for " + String.valueOf(this));
        }
        return definition.width();
    }

    @Override
    public float height() {
        EntityTypeDefinition definition = (EntityTypeDefinition)Registries.JAVA_ENTITY_TYPES.get(this);
        if (definition == null) {
            throw new IllegalStateException("No entity definition registered for " + String.valueOf(this));
        }
        return definition.height();
    }

    @Override
    public @Nullable GeyserEntityDefinition defaultBedrockDefinition() {
        EntityTypeDefinition definition = (EntityTypeDefinition)Registries.JAVA_ENTITY_TYPES.get(this);
        if (definition == null) {
            throw new IllegalStateException("No entity definition registered for " + String.valueOf(this));
        }
        return definition.defaultBedrockDefinition();
    }

    public boolean is(EntityType type) {
        return this.javaId == type.id();
    }

    public static GeyserEntityType ofVanilla(BuiltinEntityType builtin) {
        return VANILLA.computeIfAbsent(builtin, GeyserEntityType::new);
    }

    public static GeyserEntityType ofVanilla(Identifier javaIdentifier) {
        return GeyserEntityType.ofVanilla(BuiltinEntityType.valueOf((String)javaIdentifier.path().toUpperCase(Locale.ROOT)));
    }

    public static GeyserEntityType of(int javaId) {
        if (javaId >= 0 && javaId < BuiltinEntityType.VALUES.length) {
            return GeyserEntityType.ofVanilla(BuiltinEntityType.VALUES[javaId]);
        }
        GeyserEntityType type = (GeyserEntityType)CUSTOM.get(javaId);
        return type == null ? new GeyserEntityType(javaId) : type;
    }

    public static @Nullable GeyserEntityType of(Key javaKey) {
        if (javaKey.namespace().equals("minecraft")) {
            try {
                return GeyserEntityType.ofVanilla(MinecraftKey.keyToIdentifier(javaKey));
            }
            catch (IllegalArgumentException exception) {
                return null;
            }
        }
        return (GeyserEntityType)CUSTOM_BY_IDENTIFIER.get((Object)MinecraftKey.keyToIdentifier(javaKey));
    }

    public static GeyserEntityType of(EntityType type) {
        GeyserEntityType geyserEntityType;
        if (type instanceof BuiltinEntityType) {
            BuiltinEntityType builtin = (BuiltinEntityType)type;
            geyserEntityType = GeyserEntityType.ofVanilla(builtin);
        } else {
            geyserEntityType = GeyserEntityType.of(type.id());
        }
        return geyserEntityType;
    }

    public static GeyserEntityType createCustomAndRegister(Builder builder) {
        Identifier javaIdentifier = Objects.requireNonNull(builder.identifier, "javaIdentifier may not be null");
        int javaId = builder.javaId;
        if (javaIdentifier.vanilla()) {
            throw new IllegalArgumentException("Cannot register custom entity type in vanilla namespace!" + String.valueOf(javaIdentifier));
        }
        if (javaId < 0) {
            throw new IllegalArgumentException("Invalid ID (may not be below zero): " + javaId);
        }
        if (javaId < BuiltinEntityType.VALUES.length) {
            throw new IllegalArgumentException("Invalid ID (conflicts with vanilla entity type): " + javaId);
        }
        if (CUSTOM.containsKey(javaId) || CUSTOM_BY_IDENTIFIER.containsKey((Object)javaIdentifier)) {
            throw new IllegalArgumentException("Custom entity type with identifier " + String.valueOf(javaIdentifier) + " and ID " + javaId + " conflicts with existing custom entity type");
        }
        GeyserEntityType type = new GeyserEntityType(javaIdentifier, javaId);
        CUSTOM.put(javaId, (Object)type);
        CUSTOM_BY_IDENTIFIER.put((Object)javaIdentifier, (Object)type);
        return type;
    }

    public static class Builder
    implements CustomJavaEntityType.Builder {
        private Identifier identifier;
        private int javaId;
        private float width;
        private float height;
        private BedrockEntityDefinition defaultBedrockDefinition;

        @Override
        public Builder type(@NonNull Identifier entityType) {
            Objects.requireNonNull(entityType, "entityType may not be null");
            if (entityType.vanilla()) {
                throw new IllegalArgumentException("Cannot register custom entity type in vanilla namespace!" + String.valueOf(entityType));
            }
            if (CUSTOM_BY_IDENTIFIER.containsKey((Object)entityType)) {
                throw new IllegalArgumentException("Custom entity type with identifier " + String.valueOf(entityType) + " already exists!");
            }
            this.identifier = entityType;
            return this;
        }

        @Override
        public Builder javaId(int javaId) {
            if (javaId < 0) {
                throw new IllegalArgumentException("Invalid custom entity type id (may not be negative): " + javaId);
            }
            if (javaId < BuiltinEntityType.VALUES.length) {
                throw new IllegalArgumentException("Invalid custom entity type id (conflicts with vanilla entity type): " + javaId);
            }
            if (CUSTOM.containsKey(javaId)) {
                throw new IllegalArgumentException("Custom entity type with id " + javaId + " already exists!");
            }
            this.javaId = javaId;
            return this;
        }

        @Override
        public Builder width(@NonNegative float width) {
            if (width < 0.0f) {
                throw new IllegalArgumentException("Invalid custom entity type width (may not be negative): " + width);
            }
            this.width = width;
            return this;
        }

        @Override
        public Builder height(@NonNegative float height) {
            if (height < 0.0f) {
                throw new IllegalArgumentException("Invalid custom entity type height (may not be negative): " + height);
            }
            this.height = height;
            return this;
        }

        @Override
        public Builder definition(@Nullable GeyserEntityDefinition defaultBedrockDefinition) {
            if (defaultBedrockDefinition == null) {
                this.defaultBedrockDefinition = null;
            } else if (defaultBedrockDefinition instanceof BedrockEntityDefinition) {
                BedrockEntityDefinition bedrockEntityDefinition;
                this.defaultBedrockDefinition = bedrockEntityDefinition = (BedrockEntityDefinition)defaultBedrockDefinition;
            } else {
                throw new IllegalArgumentException("Invalid default geyser definition: " + String.valueOf(defaultBedrockDefinition));
            }
            return this;
        }

        @Generated
        public Identifier getIdentifier() {
            return this.identifier;
        }

        @Generated
        public int getJavaId() {
            return this.javaId;
        }

        @Generated
        public float getWidth() {
            return this.width;
        }

        @Generated
        public float getHeight() {
            return this.height;
        }

        @Generated
        public BedrockEntityDefinition getDefaultBedrockDefinition() {
            return this.defaultBedrockDefinition;
        }
    }
}

