/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.TestInstanceBlockEntity;

public class ServerboundTestInstanceBlockActionPacket
implements MinecraftPacket {
    private final Vector3i pos;
    private final int action;
    private final TestInstanceBlockEntity data;

    public ServerboundTestInstanceBlockActionPacket(ByteBuf in) {
        this.pos = MinecraftTypes.readPosition(in);
        this.action = MinecraftTypes.readVarInt(in);
        this.data = MinecraftTypes.readTestBlockEntity(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writePosition(out, this.pos);
        MinecraftTypes.writeVarInt(out, this.action);
        MinecraftTypes.writeTestBlockEntity(out, this.data);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public Vector3i getPos() {
        return this.pos;
    }

    public int getAction() {
        return this.action;
    }

    public TestInstanceBlockEntity getData() {
        return this.data;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundTestInstanceBlockActionPacket)) {
            return false;
        }
        ServerboundTestInstanceBlockActionPacket other = (ServerboundTestInstanceBlockActionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAction() != other.getAction()) {
            return false;
        }
        Vector3i this$pos = this.getPos();
        Vector3i other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
            return false;
        }
        TestInstanceBlockEntity this$data = this.getData();
        TestInstanceBlockEntity other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundTestInstanceBlockActionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAction();
        Vector3i $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        TestInstanceBlockEntity $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundTestInstanceBlockActionPacket(pos=" + String.valueOf(this.getPos()) + ", action=" + this.getAction() + ", data=" + String.valueOf(this.getData()) + ")";
    }

    public @NonNull ServerboundTestInstanceBlockActionPacket withPos(Vector3i pos) {
        return this.pos == pos ? this : new ServerboundTestInstanceBlockActionPacket(pos, this.action, this.data);
    }

    public @NonNull ServerboundTestInstanceBlockActionPacket withAction(int action) {
        return this.action == action ? this : new ServerboundTestInstanceBlockActionPacket(this.pos, action, this.data);
    }

    public @NonNull ServerboundTestInstanceBlockActionPacket withData(TestInstanceBlockEntity data) {
        return this.data == data ? this : new ServerboundTestInstanceBlockActionPacket(this.pos, this.action, data);
    }

    public ServerboundTestInstanceBlockActionPacket(Vector3i pos, int action, TestInstanceBlockEntity data) {
        this.pos = pos;
        this.action = action;
        this.data = data;
    }
}

